package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateComponentRequest(
    appId: String,
    clientToken: Option[String] = None,
    componentToCreate: zio.aws.amplifyuibuilder.model.CreateComponentData,
    environmentName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentRequest = {
    import CreateComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentRequest
      .builder()
      .appId(appId: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .componentToCreate(componentToCreate.buildAwsValue())
      .environmentName(environmentName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.CreateComponentRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.CreateComponentRequest.wrap(buildAwsValue())
}
object CreateComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CreateComponentRequest =
      zio.aws.amplifyuibuilder.model.CreateComponentRequest(
        appId,
        clientToken.map(value => value),
        componentToCreate.asEditable,
        environmentName
      )
    def appId: String
    def clientToken: Option[String]
    def componentToCreate
        : zio.aws.amplifyuibuilder.model.CreateComponentData.ReadOnly
    def environmentName: String
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getComponentToCreate: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.CreateComponentData.ReadOnly
    ] = ZIO.succeed(componentToCreate)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentRequest
  ) extends zio.aws.amplifyuibuilder.model.CreateComponentRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val componentToCreate
        : zio.aws.amplifyuibuilder.model.CreateComponentData.ReadOnly =
      zio.aws.amplifyuibuilder.model.CreateComponentData
        .wrap(impl.componentToCreate())
    override val environmentName: String = impl.environmentName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentRequest
  ): zio.aws.amplifyuibuilder.model.CreateComponentRequest.ReadOnly =
    new Wrapper(impl)
}
