package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListThemesResponse(
    entities: Iterable[zio.aws.amplifyuibuilder.model.ThemeSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse = {
    import ListThemesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse
      .builder()
      .entities(entities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ListThemesResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.ListThemesResponse.wrap(buildAwsValue())
}
object ListThemesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ListThemesResponse =
      zio.aws.amplifyuibuilder.model.ListThemesResponse(
        entities.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def entities: List[zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly]
    def nextToken: Optional[String]
    def getEntities: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly
    ]] = ZIO.succeed(entities)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse
  ) extends zio.aws.amplifyuibuilder.model.ListThemesResponse.ReadOnly {
    override val entities
        : List[zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly] = impl
      .entities()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.ThemeSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse
  ): zio.aws.amplifyuibuilder.model.ListThemesResponse.ReadOnly = new Wrapper(
    impl
  )
}
