package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CodegenGenericDataRelationshipType(
    `type`: zio.aws.amplifyuibuilder.model.GenericDataRelationshipType,
    relatedModelName: String,
    relatedModelFields: Optional[Iterable[String]] = Optional.Absent,
    canUnlinkAssociatedModel: Optional[Boolean] = Optional.Absent,
    relatedJoinFieldName: Optional[String] = Optional.Absent,
    relatedJoinTableName: Optional[String] = Optional.Absent,
    belongsToFieldOnRelatedModel: Optional[String] = Optional.Absent,
    associatedFields: Optional[Iterable[String]] = Optional.Absent,
    isHasManyIndex: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataRelationshipType = {
    import CodegenGenericDataRelationshipType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataRelationshipType
      .builder()
      .`type`(`type`.unwrap)
      .relatedModelName(relatedModelName: java.lang.String)
      .optionallyWith(
        relatedModelFields.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.relatedModelFields)
      .optionallyWith(
        canUnlinkAssociatedModel.map(value => value: java.lang.Boolean)
      )(_.canUnlinkAssociatedModel)
      .optionallyWith(
        relatedJoinFieldName.map(value => value: java.lang.String)
      )(_.relatedJoinFieldName)
      .optionallyWith(
        relatedJoinTableName.map(value => value: java.lang.String)
      )(_.relatedJoinTableName)
      .optionallyWith(
        belongsToFieldOnRelatedModel.map(value => value: java.lang.String)
      )(_.belongsToFieldOnRelatedModel)
      .optionallyWith(
        associatedFields.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.associatedFields)
      .optionallyWith(isHasManyIndex.map(value => value: java.lang.Boolean))(
        _.isHasManyIndex
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.CodegenGenericDataRelationshipType.ReadOnly =
    zio.aws.amplifyuibuilder.model.CodegenGenericDataRelationshipType
      .wrap(buildAwsValue())
}
object CodegenGenericDataRelationshipType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataRelationshipType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifyuibuilder.model.CodegenGenericDataRelationshipType =
      zio.aws.amplifyuibuilder.model.CodegenGenericDataRelationshipType(
        `type`,
        relatedModelName,
        relatedModelFields.map(value => value),
        canUnlinkAssociatedModel.map(value => value),
        relatedJoinFieldName.map(value => value),
        relatedJoinTableName.map(value => value),
        belongsToFieldOnRelatedModel.map(value => value),
        associatedFields.map(value => value),
        isHasManyIndex.map(value => value)
      )
    def `type`: zio.aws.amplifyuibuilder.model.GenericDataRelationshipType
    def relatedModelName: String
    def relatedModelFields: Optional[List[String]]
    def canUnlinkAssociatedModel: Optional[Boolean]
    def relatedJoinFieldName: Optional[String]
    def relatedJoinTableName: Optional[String]
    def belongsToFieldOnRelatedModel: Optional[String]
    def associatedFields: Optional[List[String]]
    def isHasManyIndex: Optional[Boolean]
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.GenericDataRelationshipType
    ] = ZIO.succeed(`type`)
    def getRelatedModelName: ZIO[Any, Nothing, String] =
      ZIO.succeed(relatedModelName)
    def getRelatedModelFields: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("relatedModelFields", relatedModelFields)
    def getCanUnlinkAssociatedModel: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("canUnlinkAssociatedModel", canUnlinkAssociatedModel)
    def getRelatedJoinFieldName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("relatedJoinFieldName", relatedJoinFieldName)
    def getRelatedJoinTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("relatedJoinTableName", relatedJoinTableName)
    def getBelongsToFieldOnRelatedModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "belongsToFieldOnRelatedModel",
        belongsToFieldOnRelatedModel
      )
    def getAssociatedFields: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("associatedFields", associatedFields)
    def getIsHasManyIndex: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isHasManyIndex", isHasManyIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataRelationshipType
  ) extends zio.aws.amplifyuibuilder.model.CodegenGenericDataRelationshipType.ReadOnly {
    override val `type`
        : zio.aws.amplifyuibuilder.model.GenericDataRelationshipType =
      zio.aws.amplifyuibuilder.model.GenericDataRelationshipType
        .wrap(impl.`type`())
    override val relatedModelName: String = impl.relatedModelName(): String
    override val relatedModelFields: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedModelFields())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val canUnlinkAssociatedModel: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canUnlinkAssociatedModel())
        .map(value => value: Boolean)
    override val relatedJoinFieldName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.relatedJoinFieldName())
      .map(value => value: String)
    override val relatedJoinTableName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.relatedJoinTableName())
      .map(value => value: String)
    override val belongsToFieldOnRelatedModel: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.belongsToFieldOnRelatedModel())
        .map(value => value: String)
    override val associatedFields: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedFields())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val isHasManyIndex: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isHasManyIndex())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataRelationshipType
  ): zio.aws.amplifyuibuilder.model.CodegenGenericDataRelationshipType.ReadOnly =
    new Wrapper(impl)
}
