package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FormInputValueProperty(
    value: Optional[String] = Optional.Absent,
    bindingProperties: Optional[
      zio.aws.amplifyuibuilder.model.FormInputValuePropertyBindingProperties
    ] = Optional.Absent,
    concat: Optional[
      Iterable[zio.aws.amplifyuibuilder.model.FormInputValueProperty]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty = {
    import FormInputValueProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(bindingProperties.map(value => value.buildAwsValue()))(
        _.bindingProperties
      )
      .optionallyWith(
        concat.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.concat)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly =
    zio.aws.amplifyuibuilder.model.FormInputValueProperty.wrap(buildAwsValue())
}
object FormInputValueProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FormInputValueProperty =
      zio.aws.amplifyuibuilder.model.FormInputValueProperty(
        value.map(value => value),
        bindingProperties.map(value => value.asEditable),
        concat.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def value: Optional[String]
    def bindingProperties: Optional[
      zio.aws.amplifyuibuilder.model.FormInputValuePropertyBindingProperties.ReadOnly
    ]
    def concat: Optional[
      List[zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly]
    ]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getBindingProperties: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormInputValuePropertyBindingProperties.ReadOnly
    ] = AwsError.unwrapOptionField("bindingProperties", bindingProperties)
    def getConcat: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("concat", concat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty
  ) extends zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val bindingProperties: Optional[
      zio.aws.amplifyuibuilder.model.FormInputValuePropertyBindingProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bindingProperties())
      .map(value =>
        zio.aws.amplifyuibuilder.model.FormInputValuePropertyBindingProperties
          .wrap(value)
      )
    override val concat: Optional[
      List[zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.concat())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplifyuibuilder.model.FormInputValueProperty.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty
  ): zio.aws.amplifyuibuilder.model.FormInputValueProperty.ReadOnly =
    new Wrapper(impl)
}
