package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCodegenJobResponse(
    job: Optional[zio.aws.amplifyuibuilder.model.CodegenJob] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobResponse = {
    import GetCodegenJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobResponse
      .builder()
      .optionallyWith(job.map(value => value.buildAwsValue()))(_.job)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.GetCodegenJobResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.GetCodegenJobResponse.wrap(buildAwsValue())
}
object GetCodegenJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.GetCodegenJobResponse =
      zio.aws.amplifyuibuilder.model
        .GetCodegenJobResponse(job.map(value => value.asEditable))
    def job: Optional[zio.aws.amplifyuibuilder.model.CodegenJob.ReadOnly]
    def getJob: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.CodegenJob.ReadOnly
    ] = AwsError.unwrapOptionField("job", job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobResponse
  ) extends zio.aws.amplifyuibuilder.model.GetCodegenJobResponse.ReadOnly {
    override val job
        : Optional[zio.aws.amplifyuibuilder.model.CodegenJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.job())
        .map(value => zio.aws.amplifyuibuilder.model.CodegenJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetCodegenJobResponse
  ): zio.aws.amplifyuibuilder.model.GetCodegenJobResponse.ReadOnly =
    new Wrapper(impl)
}
