package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReactStartCodegenJobData(
    module: Optional[zio.aws.amplifyuibuilder.model.JSModule] = Optional.Absent,
    target: Optional[zio.aws.amplifyuibuilder.model.JSTarget] = Optional.Absent,
    script: Optional[zio.aws.amplifyuibuilder.model.JSScript] = Optional.Absent,
    renderTypeDeclarations: Optional[Boolean] = Optional.Absent,
    inlineSourceMap: Optional[Boolean] = Optional.Absent,
    apiConfiguration: Optional[
      zio.aws.amplifyuibuilder.model.ApiConfiguration
    ] = Optional.Absent,
    dependencies: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ReactStartCodegenJobData = {
    import ReactStartCodegenJobData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ReactStartCodegenJobData
      .builder()
      .optionallyWith(module.map(value => value.unwrap))(_.module)
      .optionallyWith(target.map(value => value.unwrap))(_.target)
      .optionallyWith(script.map(value => value.unwrap))(_.script)
      .optionallyWith(
        renderTypeDeclarations.map(value => value: java.lang.Boolean)
      )(_.renderTypeDeclarations)
      .optionallyWith(inlineSourceMap.map(value => value: java.lang.Boolean))(
        _.inlineSourceMap
      )
      .optionallyWith(apiConfiguration.map(value => value.buildAwsValue()))(
        _.apiConfiguration
      )
      .optionallyWith(
        dependencies.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.dependencies)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ReactStartCodegenJobData.ReadOnly =
    zio.aws.amplifyuibuilder.model.ReactStartCodegenJobData
      .wrap(buildAwsValue())
}
object ReactStartCodegenJobData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ReactStartCodegenJobData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ReactStartCodegenJobData =
      zio.aws.amplifyuibuilder.model.ReactStartCodegenJobData(
        module.map(value => value),
        target.map(value => value),
        script.map(value => value),
        renderTypeDeclarations.map(value => value),
        inlineSourceMap.map(value => value),
        apiConfiguration.map(value => value.asEditable),
        dependencies.map(value => value)
      )
    def module: Optional[zio.aws.amplifyuibuilder.model.JSModule]
    def target: Optional[zio.aws.amplifyuibuilder.model.JSTarget]
    def script: Optional[zio.aws.amplifyuibuilder.model.JSScript]
    def renderTypeDeclarations: Optional[Boolean]
    def inlineSourceMap: Optional[Boolean]
    def apiConfiguration
        : Optional[zio.aws.amplifyuibuilder.model.ApiConfiguration.ReadOnly]
    def dependencies: Optional[Map[String, String]]
    def getModule: ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.JSModule] =
      AwsError.unwrapOptionField("module", module)
    def getTarget: ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.JSTarget] =
      AwsError.unwrapOptionField("target", target)
    def getScript: ZIO[Any, AwsError, zio.aws.amplifyuibuilder.model.JSScript] =
      AwsError.unwrapOptionField("script", script)
    def getRenderTypeDeclarations: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("renderTypeDeclarations", renderTypeDeclarations)
    def getInlineSourceMap: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("inlineSourceMap", inlineSourceMap)
    def getApiConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ApiConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("apiConfiguration", apiConfiguration)
    def getDependencies: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("dependencies", dependencies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ReactStartCodegenJobData
  ) extends zio.aws.amplifyuibuilder.model.ReactStartCodegenJobData.ReadOnly {
    override val module: Optional[zio.aws.amplifyuibuilder.model.JSModule] =
      zio.aws.core.internal
        .optionalFromNullable(impl.module())
        .map(value => zio.aws.amplifyuibuilder.model.JSModule.wrap(value))
    override val target: Optional[zio.aws.amplifyuibuilder.model.JSTarget] =
      zio.aws.core.internal
        .optionalFromNullable(impl.target())
        .map(value => zio.aws.amplifyuibuilder.model.JSTarget.wrap(value))
    override val script: Optional[zio.aws.amplifyuibuilder.model.JSScript] =
      zio.aws.core.internal
        .optionalFromNullable(impl.script())
        .map(value => zio.aws.amplifyuibuilder.model.JSScript.wrap(value))
    override val renderTypeDeclarations: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renderTypeDeclarations())
        .map(value => value: Boolean)
    override val inlineSourceMap: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.inlineSourceMap())
      .map(value => value: Boolean)
    override val apiConfiguration
        : Optional[zio.aws.amplifyuibuilder.model.ApiConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiConfiguration())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ApiConfiguration.wrap(value)
        )
    override val dependencies: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dependencies())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ReactStartCodegenJobData
  ): zio.aws.amplifyuibuilder.model.ReactStartCodegenJobData.ReadOnly =
    new Wrapper(impl)
}
