package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CodegenGenericDataModel(
    fields: Map[String, zio.aws.amplifyuibuilder.model.CodegenGenericDataField],
    isJoinTable: Optional[Boolean] = Optional.Absent,
    primaryKeys: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataModel = {
    import CodegenGenericDataModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataModel
      .builder()
      .fields(
        fields
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(isJoinTable.map(value => value: java.lang.Boolean))(
        _.isJoinTable
      )
      .primaryKeys(primaryKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.CodegenGenericDataModel.ReadOnly =
    zio.aws.amplifyuibuilder.model.CodegenGenericDataModel.wrap(buildAwsValue())
}
object CodegenGenericDataModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CodegenGenericDataModel =
      zio.aws.amplifyuibuilder.model.CodegenGenericDataModel(
        fields.map({ case (key, value) =>
          key -> value.asEditable
        }),
        isJoinTable.map(value => value),
        primaryKeys
      )
    def fields: Map[
      String,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataField.ReadOnly
    ]
    def isJoinTable: Optional[Boolean]
    def primaryKeys: List[String]
    def getFields: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataField.ReadOnly
    ]] = ZIO.succeed(fields)
    def getIsJoinTable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isJoinTable", isJoinTable)
    def getPrimaryKeys: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(primaryKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataModel
  ) extends zio.aws.amplifyuibuilder.model.CodegenGenericDataModel.ReadOnly {
    override val fields: Map[
      String,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataField.ReadOnly
    ] = impl
      .fields()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.CodegenGenericDataField
          .wrap(value)
      })
      .toMap
    override val isJoinTable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isJoinTable())
      .map(value => value: Boolean)
    override val primaryKeys: List[String] = impl
      .primaryKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataModel
  ): zio.aws.amplifyuibuilder.model.CodegenGenericDataModel.ReadOnly =
    new Wrapper(impl)
}
