package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApiConfiguration(
    graphQLConfig: Optional[
      zio.aws.amplifyuibuilder.model.GraphQLRenderConfig
    ] = Optional.Absent,
    dataStoreConfig: Optional[
      zio.aws.amplifyuibuilder.model.DataStoreRenderConfig
    ] = Optional.Absent,
    noApiConfig: Optional[zio.aws.amplifyuibuilder.model.NoApiRenderConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ApiConfiguration = {
    import ApiConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ApiConfiguration
      .builder()
      .optionallyWith(graphQLConfig.map(value => value.buildAwsValue()))(
        _.graphQLConfig
      )
      .optionallyWith(dataStoreConfig.map(value => value.buildAwsValue()))(
        _.dataStoreConfig
      )
      .optionallyWith(noApiConfig.map(value => value.buildAwsValue()))(
        _.noApiConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ApiConfiguration.ReadOnly =
    zio.aws.amplifyuibuilder.model.ApiConfiguration.wrap(buildAwsValue())
}
object ApiConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ApiConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ApiConfiguration =
      zio.aws.amplifyuibuilder.model.ApiConfiguration(
        graphQLConfig.map(value => value.asEditable),
        dataStoreConfig.map(value => value.asEditable),
        noApiConfig.map(value => value.asEditable)
      )
    def graphQLConfig
        : Optional[zio.aws.amplifyuibuilder.model.GraphQLRenderConfig.ReadOnly]
    def dataStoreConfig: Optional[
      zio.aws.amplifyuibuilder.model.DataStoreRenderConfig.ReadOnly
    ]
    def noApiConfig
        : Optional[zio.aws.amplifyuibuilder.model.NoApiRenderConfig.ReadOnly]
    def getGraphQLConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.GraphQLRenderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("graphQLConfig", graphQLConfig)
    def getDataStoreConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.DataStoreRenderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataStoreConfig", dataStoreConfig)
    def getNoApiConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.NoApiRenderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("noApiConfig", noApiConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ApiConfiguration
  ) extends zio.aws.amplifyuibuilder.model.ApiConfiguration.ReadOnly {
    override val graphQLConfig: Optional[
      zio.aws.amplifyuibuilder.model.GraphQLRenderConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.graphQLConfig())
      .map(value =>
        zio.aws.amplifyuibuilder.model.GraphQLRenderConfig.wrap(value)
      )
    override val dataStoreConfig: Optional[
      zio.aws.amplifyuibuilder.model.DataStoreRenderConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataStoreConfig())
      .map(value =>
        zio.aws.amplifyuibuilder.model.DataStoreRenderConfig.wrap(value)
      )
    override val noApiConfig
        : Optional[zio.aws.amplifyuibuilder.model.NoApiRenderConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noApiConfig())
        .map(value =>
          zio.aws.amplifyuibuilder.model.NoApiRenderConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ApiConfiguration
  ): zio.aws.amplifyuibuilder.model.ApiConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
