package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FormInputBindingPropertiesValueProperties(
    model: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FormInputBindingPropertiesValueProperties = {
    import FormInputBindingPropertiesValueProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FormInputBindingPropertiesValueProperties
      .builder()
      .optionallyWith(model.map(value => value: java.lang.String))(_.model)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.FormInputBindingPropertiesValueProperties.ReadOnly =
    zio.aws.amplifyuibuilder.model.FormInputBindingPropertiesValueProperties
      .wrap(buildAwsValue())
}
object FormInputBindingPropertiesValueProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FormInputBindingPropertiesValueProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifyuibuilder.model.FormInputBindingPropertiesValueProperties =
      zio.aws.amplifyuibuilder.model
        .FormInputBindingPropertiesValueProperties(model.map(value => value))
    def model: Optional[String]
    def getModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("model", model)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormInputBindingPropertiesValueProperties
  ) extends zio.aws.amplifyuibuilder.model.FormInputBindingPropertiesValueProperties.ReadOnly {
    override val model: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.model())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormInputBindingPropertiesValueProperties
  ): zio.aws.amplifyuibuilder.model.FormInputBindingPropertiesValueProperties.ReadOnly =
    new Wrapper(impl)
}
