package zio.aws.amplifyuibuilder.model
import scala.jdk.CollectionConverters._
sealed trait StorageAccessLevel {
  def unwrap: software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel
}
object StorageAccessLevel {
  def wrap(
      value: software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel
  ): zio.aws.amplifyuibuilder.model.StorageAccessLevel = value match {
    case software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel.PUBLIC =>
      val r = public
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel.PROTECTED =>
      val r = `protected`
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel.PRIVATE =>
      val r = `private`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifyuibuilder.model.StorageAccessLevel {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel =
      software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object public extends zio.aws.amplifyuibuilder.model.StorageAccessLevel {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel =
      software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel.PUBLIC
  }
  case object `protected`
      extends zio.aws.amplifyuibuilder.model.StorageAccessLevel {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel =
      software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel.PROTECTED
  }
  case object `private`
      extends zio.aws.amplifyuibuilder.model.StorageAccessLevel {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel =
      software.amazon.awssdk.services.amplifyuibuilder.model.StorageAccessLevel.PRIVATE
  }
}
