package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FieldInputConfig(
    `type`: String,
    required: Optional[Boolean] = Optional.Absent,
    readOnly: Optional[Boolean] = Optional.Absent,
    placeholder: Optional[String] = Optional.Absent,
    defaultValue: Optional[String] = Optional.Absent,
    descriptiveText: Optional[String] = Optional.Absent,
    defaultChecked: Optional[Boolean] = Optional.Absent,
    defaultCountryCode: Optional[String] = Optional.Absent,
    valueMappings: Optional[zio.aws.amplifyuibuilder.model.ValueMappings] =
      Optional.Absent,
    name: Optional[String] = Optional.Absent,
    minValue: Optional[Float] = Optional.Absent,
    maxValue: Optional[Float] = Optional.Absent,
    step: Optional[Float] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    isArray: Optional[Boolean] = Optional.Absent,
    fileUploaderConfig: Optional[
      zio.aws.amplifyuibuilder.model.FileUploaderFieldConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FieldInputConfig = {
    import FieldInputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FieldInputConfig
      .builder()
      .`type`(`type`: java.lang.String)
      .optionallyWith(required.map(value => value: java.lang.Boolean))(
        _.required
      )
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .optionallyWith(placeholder.map(value => value: java.lang.String))(
        _.placeholder
      )
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(descriptiveText.map(value => value: java.lang.String))(
        _.descriptiveText
      )
      .optionallyWith(defaultChecked.map(value => value: java.lang.Boolean))(
        _.defaultChecked
      )
      .optionallyWith(defaultCountryCode.map(value => value: java.lang.String))(
        _.defaultCountryCode
      )
      .optionallyWith(valueMappings.map(value => value.buildAwsValue()))(
        _.valueMappings
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(minValue.map(value => value: java.lang.Float))(_.minValue)
      .optionallyWith(maxValue.map(value => value: java.lang.Float))(_.maxValue)
      .optionallyWith(step.map(value => value: java.lang.Float))(_.step)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(isArray.map(value => value: java.lang.Boolean))(_.isArray)
      .optionallyWith(fileUploaderConfig.map(value => value.buildAwsValue()))(
        _.fileUploaderConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.FieldInputConfig.ReadOnly =
    zio.aws.amplifyuibuilder.model.FieldInputConfig.wrap(buildAwsValue())
}
object FieldInputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FieldInputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FieldInputConfig =
      zio.aws.amplifyuibuilder.model.FieldInputConfig(
        `type`,
        required.map(value => value),
        readOnly.map(value => value),
        placeholder.map(value => value),
        defaultValue.map(value => value),
        descriptiveText.map(value => value),
        defaultChecked.map(value => value),
        defaultCountryCode.map(value => value),
        valueMappings.map(value => value.asEditable),
        name.map(value => value),
        minValue.map(value => value),
        maxValue.map(value => value),
        step.map(value => value),
        value.map(value => value),
        isArray.map(value => value),
        fileUploaderConfig.map(value => value.asEditable)
      )
    def `type`: String
    def required: Optional[Boolean]
    def readOnly: Optional[Boolean]
    def placeholder: Optional[String]
    def defaultValue: Optional[String]
    def descriptiveText: Optional[String]
    def defaultChecked: Optional[Boolean]
    def defaultCountryCode: Optional[String]
    def valueMappings
        : Optional[zio.aws.amplifyuibuilder.model.ValueMappings.ReadOnly]
    def name: Optional[String]
    def minValue: Optional[Float]
    def maxValue: Optional[Float]
    def step: Optional[Float]
    def value: Optional[String]
    def isArray: Optional[Boolean]
    def fileUploaderConfig: Optional[
      zio.aws.amplifyuibuilder.model.FileUploaderFieldConfig.ReadOnly
    ]
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("required", required)
    def getReadOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getPlaceholder: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("placeholder", placeholder)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDescriptiveText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("descriptiveText", descriptiveText)
    def getDefaultChecked: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultChecked", defaultChecked)
    def getDefaultCountryCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultCountryCode", defaultCountryCode)
    def getValueMappings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ValueMappings.ReadOnly
    ] = AwsError.unwrapOptionField("valueMappings", valueMappings)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getMinValue: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("minValue", minValue)
    def getMaxValue: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("maxValue", maxValue)
    def getStep: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("step", step)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getIsArray: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isArray", isArray)
    def getFileUploaderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FileUploaderFieldConfig.ReadOnly
    ] = AwsError.unwrapOptionField("fileUploaderConfig", fileUploaderConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FieldInputConfig
  ) extends zio.aws.amplifyuibuilder.model.FieldInputConfig.ReadOnly {
    override val `type`: String = impl.`type`(): String
    override val required: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.required())
      .map(value => value: Boolean)
    override val readOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.readOnly())
      .map(value => value: Boolean)
    override val placeholder: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.placeholder())
      .map(value => value: String)
    override val defaultValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => value: String)
    override val descriptiveText: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.descriptiveText())
      .map(value => value: String)
    override val defaultChecked: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultChecked())
      .map(value => value: Boolean)
    override val defaultCountryCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultCountryCode())
      .map(value => value: String)
    override val valueMappings
        : Optional[zio.aws.amplifyuibuilder.model.ValueMappings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.valueMappings())
        .map(value => zio.aws.amplifyuibuilder.model.ValueMappings.wrap(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val minValue: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.minValue())
      .map(value => value: Float)
    override val maxValue: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.maxValue())
      .map(value => value: Float)
    override val step: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.step())
      .map(value => value: Float)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val isArray: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isArray())
      .map(value => value: Boolean)
    override val fileUploaderConfig: Optional[
      zio.aws.amplifyuibuilder.model.FileUploaderFieldConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fileUploaderConfig())
      .map(value =>
        zio.aws.amplifyuibuilder.model.FileUploaderFieldConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FieldInputConfig
  ): zio.aws.amplifyuibuilder.model.FieldInputConfig.ReadOnly = new Wrapper(
    impl
  )
}
