package zio.aws.amplifyuibuilder
import zio.aws.amplifyuibuilder.model.GetMetadataResponse.ReadOnly
import software.amazon.awssdk.services.amplifyuibuilder.model.{
  CreateComponentResponse,
  UpdateComponentResponse,
  Theme,
  ListThemesRequest,
  ExportFormsResponse,
  ExportThemesRequest,
  GetCodegenJobRequest,
  DeleteThemeResponse,
  UpdateFormResponse,
  ListThemesResponse,
  UpdateFormRequest,
  ExportComponentsRequest,
  ThemeSummary,
  GetThemeResponse,
  Component,
  DeleteComponentRequest,
  DeleteFormRequest,
  ListCodegenJobsRequest,
  PutMetadataFlagRequest,
  DeleteComponentResponse,
  ListCodegenJobsResponse,
  GetComponentResponse,
  ComponentSummary,
  CreateComponentRequest,
  ExportFormsRequest,
  UpdateThemeResponse,
  PutMetadataFlagResponse,
  StartCodegenJobResponse,
  RefreshTokenRequest,
  DeleteFormResponse,
  ExchangeCodeForTokenResponse,
  GetThemeRequest,
  GetMetadataResponse,
  DeleteThemeRequest,
  ListFormsResponse,
  ExportThemesResponse,
  ListFormsRequest,
  GetMetadataRequest,
  ExchangeCodeForTokenRequest,
  ExportComponentsResponse,
  Form,
  GetCodegenJobResponse,
  FormSummary,
  UpdateComponentRequest,
  CreateThemeResponse,
  RefreshTokenResponse,
  ListComponentsRequest,
  CreateThemeRequest,
  UpdateThemeRequest,
  ListComponentsResponse,
  GetComponentRequest,
  CodegenJobSummary,
  GetFormRequest,
  CreateFormRequest,
  StartCodegenJobRequest,
  GetFormResponse,
  CreateFormResponse
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.amplifyuibuilder.{
  AmplifyUiBuilderAsyncClientBuilder,
  AmplifyUiBuilderAsyncClient
}
import zio.stream.ZStream
import software.amazon.awssdk.services.amplifyuibuilder.paginators.{
  ListCodegenJobsPublisher,
  ExportComponentsPublisher,
  ListFormsPublisher,
  ListThemesPublisher,
  ExportFormsPublisher,
  ListComponentsPublisher,
  ExportThemesPublisher
}
import scala.jdk.CollectionConverters._
trait AmplifyUiBuilder extends AspectSupport[AmplifyUiBuilder] {
  val api: AmplifyUiBuilderAsyncClient
  def getMetadata(
      request: zio.aws.amplifyuibuilder.model.GetMetadataRequest
  ): IO[AwsError, ReadOnly]
  def exportThemes(
      request: zio.aws.amplifyuibuilder.model.ExportThemesRequest
  ): ZStream[Any, AwsError, zio.aws.amplifyuibuilder.model.Theme.ReadOnly]
  def exportThemesPaginated(
      request: zio.aws.amplifyuibuilder.model.ExportThemesRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly]
  def putMetadataFlag(
      request: zio.aws.amplifyuibuilder.model.PutMetadataFlagRequest
  ): IO[AwsError, Unit]
  def exportComponents(
      request: zio.aws.amplifyuibuilder.model.ExportComponentsRequest
  ): ZStream[Any, AwsError, zio.aws.amplifyuibuilder.model.Component.ReadOnly]
  def exportComponentsPaginated(
      request: zio.aws.amplifyuibuilder.model.ExportComponentsRequest
  ): IO[
    AwsError,
    zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly
  ]
  def deleteTheme(
      request: zio.aws.amplifyuibuilder.model.DeleteThemeRequest
  ): IO[AwsError, Unit]
  def createTheme(
      request: zio.aws.amplifyuibuilder.model.CreateThemeRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.CreateThemeResponse.ReadOnly]
  def listThemes(
      request: zio.aws.amplifyuibuilder.model.ListThemesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly
  ]
  def listThemesPaginated(
      request: zio.aws.amplifyuibuilder.model.ListThemesRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.ListThemesResponse.ReadOnly]
  def getForm(
      request: zio.aws.amplifyuibuilder.model.GetFormRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.GetFormResponse.ReadOnly]
  def listCodegenJobs(
      request: zio.aws.amplifyuibuilder.model.ListCodegenJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.amplifyuibuilder.model.CodegenJobSummary.ReadOnly
  ]
  def listCodegenJobsPaginated(
      request: zio.aws.amplifyuibuilder.model.ListCodegenJobsRequest
  ): IO[
    AwsError,
    zio.aws.amplifyuibuilder.model.ListCodegenJobsResponse.ReadOnly
  ]
  def exportForms(
      request: zio.aws.amplifyuibuilder.model.ExportFormsRequest
  ): ZStream[Any, AwsError, zio.aws.amplifyuibuilder.model.Form.ReadOnly]
  def exportFormsPaginated(
      request: zio.aws.amplifyuibuilder.model.ExportFormsRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.ExportFormsResponse.ReadOnly]
  def listForms(
      request: zio.aws.amplifyuibuilder.model.ListFormsRequest
  ): ZStream[Any, AwsError, zio.aws.amplifyuibuilder.model.FormSummary.ReadOnly]
  def listFormsPaginated(
      request: zio.aws.amplifyuibuilder.model.ListFormsRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.ListFormsResponse.ReadOnly]
  def startCodegenJob(
      request: zio.aws.amplifyuibuilder.model.StartCodegenJobRequest
  ): IO[
    AwsError,
    zio.aws.amplifyuibuilder.model.StartCodegenJobResponse.ReadOnly
  ]
  def listComponents(
      request: zio.aws.amplifyuibuilder.model.ListComponentsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly
  ]
  def listComponentsPaginated(
      request: zio.aws.amplifyuibuilder.model.ListComponentsRequest
  ): IO[
    AwsError,
    zio.aws.amplifyuibuilder.model.ListComponentsResponse.ReadOnly
  ]
  def refreshToken(
      request: zio.aws.amplifyuibuilder.model.RefreshTokenRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.RefreshTokenResponse.ReadOnly]
  def updateForm(
      request: zio.aws.amplifyuibuilder.model.UpdateFormRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.UpdateFormResponse.ReadOnly]
  def getTheme(
      request: zio.aws.amplifyuibuilder.model.GetThemeRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.GetThemeResponse.ReadOnly]
  def createForm(
      request: zio.aws.amplifyuibuilder.model.CreateFormRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.CreateFormResponse.ReadOnly]
  def deleteComponent(
      request: zio.aws.amplifyuibuilder.model.DeleteComponentRequest
  ): IO[AwsError, Unit]
  def deleteForm(
      request: zio.aws.amplifyuibuilder.model.DeleteFormRequest
  ): IO[AwsError, Unit]
  def createComponent(
      request: zio.aws.amplifyuibuilder.model.CreateComponentRequest
  ): IO[
    AwsError,
    zio.aws.amplifyuibuilder.model.CreateComponentResponse.ReadOnly
  ]
  def exchangeCodeForToken(
      request: zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequest
  ): IO[
    AwsError,
    zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly
  ]
  def getCodegenJob(
      request: zio.aws.amplifyuibuilder.model.GetCodegenJobRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.GetCodegenJobResponse.ReadOnly]
  def getComponent(
      request: zio.aws.amplifyuibuilder.model.GetComponentRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.GetComponentResponse.ReadOnly]
  def updateComponent(
      request: zio.aws.amplifyuibuilder.model.UpdateComponentRequest
  ): IO[
    AwsError,
    zio.aws.amplifyuibuilder.model.UpdateComponentResponse.ReadOnly
  ]
  def updateTheme(
      request: zio.aws.amplifyuibuilder.model.UpdateThemeRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.UpdateThemeResponse.ReadOnly]
}
object AmplifyUiBuilder {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AmplifyUiBuilder] =
    customized(identity)
  def customized(
      customization: AmplifyUiBuilderAsyncClientBuilder => AmplifyUiBuilderAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AmplifyUiBuilder] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: AmplifyUiBuilderAsyncClientBuilder => AmplifyUiBuilderAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, AmplifyUiBuilder] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = AmplifyUiBuilderAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      AmplifyUiBuilderAsyncClient,
      AmplifyUiBuilderAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      AmplifyUiBuilderAsyncClient,
      AmplifyUiBuilderAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new AmplifyUiBuilderImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class AmplifyUiBuilderImpl[R](
      override val api: AmplifyUiBuilderAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AmplifyUiBuilder
      with AwsServiceBase[R] {
    override val serviceName: String = "AmplifyUiBuilder"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AmplifyUiBuilderImpl[R1] = new AmplifyUiBuilderImpl(api, newAspect, r)
    def getMetadata(
        request: zio.aws.amplifyuibuilder.model.GetMetadataRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[GetMetadataRequest, GetMetadataResponse](
        "getMetadata",
        api.getMetadata
      )(request.buildAwsValue())
        .map(zio.aws.amplifyuibuilder.model.GetMetadataResponse.wrap)
        .provideEnvironment(r)
    def exportThemes(
        request: zio.aws.amplifyuibuilder.model.ExportThemesRequest
    ): ZStream[Any, AwsError, zio.aws.amplifyuibuilder.model.Theme.ReadOnly] =
      asyncJavaPaginatedRequest[
        ExportThemesRequest,
        Theme,
        ExportThemesPublisher
      ]("exportThemes", api.exportThemesPaginator, _.entities())(
        request.buildAwsValue()
      ).map(item => zio.aws.amplifyuibuilder.model.Theme.wrap(item))
        .provideEnvironment(r)
    def exportThemesPaginated(
        request: zio.aws.amplifyuibuilder.model.ExportThemesRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly
    ] = asyncRequestResponse[ExportThemesRequest, ExportThemesResponse](
      "exportThemes",
      api.exportThemes
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.ExportThemesResponse.wrap)
      .provideEnvironment(r)
    def putMetadataFlag(
        request: zio.aws.amplifyuibuilder.model.PutMetadataFlagRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutMetadataFlagRequest, PutMetadataFlagResponse](
        "putMetadataFlag",
        api.putMetadataFlag
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def exportComponents(
        request: zio.aws.amplifyuibuilder.model.ExportComponentsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.Component.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ExportComponentsRequest,
      Component,
      ExportComponentsPublisher
    ]("exportComponents", api.exportComponentsPaginator, _.entities())(
      request.buildAwsValue()
    ).map(item => zio.aws.amplifyuibuilder.model.Component.wrap(item))
      .provideEnvironment(r)
    def exportComponentsPaginated(
        request: zio.aws.amplifyuibuilder.model.ExportComponentsRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly
    ] = asyncRequestResponse[ExportComponentsRequest, ExportComponentsResponse](
      "exportComponents",
      api.exportComponents
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.ExportComponentsResponse.wrap)
      .provideEnvironment(r)
    def deleteTheme(
        request: zio.aws.amplifyuibuilder.model.DeleteThemeRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteThemeRequest, DeleteThemeResponse](
        "deleteTheme",
        api.deleteTheme
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createTheme(
        request: zio.aws.amplifyuibuilder.model.CreateThemeRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.CreateThemeResponse.ReadOnly
    ] = asyncRequestResponse[CreateThemeRequest, CreateThemeResponse](
      "createTheme",
      api.createTheme
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.CreateThemeResponse.wrap)
      .provideEnvironment(r)
    def listThemes(
        request: zio.aws.amplifyuibuilder.model.ListThemesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListThemesRequest,
      ThemeSummary,
      ListThemesPublisher
    ]("listThemes", api.listThemesPaginator, _.entities())(
      request.buildAwsValue()
    ).map(item => zio.aws.amplifyuibuilder.model.ThemeSummary.wrap(item))
      .provideEnvironment(r)
    def listThemesPaginated(
        request: zio.aws.amplifyuibuilder.model.ListThemesRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.ListThemesResponse.ReadOnly
    ] = asyncRequestResponse[ListThemesRequest, ListThemesResponse](
      "listThemes",
      api.listThemes
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.ListThemesResponse.wrap)
      .provideEnvironment(r)
    def getForm(
        request: zio.aws.amplifyuibuilder.model.GetFormRequest
    ): IO[AwsError, zio.aws.amplifyuibuilder.model.GetFormResponse.ReadOnly] =
      asyncRequestResponse[GetFormRequest, GetFormResponse](
        "getForm",
        api.getForm
      )(request.buildAwsValue())
        .map(zio.aws.amplifyuibuilder.model.GetFormResponse.wrap)
        .provideEnvironment(r)
    def listCodegenJobs(
        request: zio.aws.amplifyuibuilder.model.ListCodegenJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.CodegenJobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListCodegenJobsRequest,
      CodegenJobSummary,
      ListCodegenJobsPublisher
    ]("listCodegenJobs", api.listCodegenJobsPaginator, _.entities())(
      request.buildAwsValue()
    ).map(item => zio.aws.amplifyuibuilder.model.CodegenJobSummary.wrap(item))
      .provideEnvironment(r)
    def listCodegenJobsPaginated(
        request: zio.aws.amplifyuibuilder.model.ListCodegenJobsRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.ListCodegenJobsResponse.ReadOnly
    ] = asyncRequestResponse[ListCodegenJobsRequest, ListCodegenJobsResponse](
      "listCodegenJobs",
      api.listCodegenJobs
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.ListCodegenJobsResponse.wrap)
      .provideEnvironment(r)
    def exportForms(
        request: zio.aws.amplifyuibuilder.model.ExportFormsRequest
    ): ZStream[Any, AwsError, zio.aws.amplifyuibuilder.model.Form.ReadOnly] =
      asyncJavaPaginatedRequest[ExportFormsRequest, Form, ExportFormsPublisher](
        "exportForms",
        api.exportFormsPaginator,
        _.entities()
      )(request.buildAwsValue())
        .map(item => zio.aws.amplifyuibuilder.model.Form.wrap(item))
        .provideEnvironment(r)
    def exportFormsPaginated(
        request: zio.aws.amplifyuibuilder.model.ExportFormsRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.ExportFormsResponse.ReadOnly
    ] = asyncRequestResponse[ExportFormsRequest, ExportFormsResponse](
      "exportForms",
      api.exportForms
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.ExportFormsResponse.wrap)
      .provideEnvironment(r)
    def listForms(
        request: zio.aws.amplifyuibuilder.model.ListFormsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListFormsRequest,
      FormSummary,
      ListFormsPublisher
    ]("listForms", api.listFormsPaginator, _.entities())(
      request.buildAwsValue()
    ).map(item => zio.aws.amplifyuibuilder.model.FormSummary.wrap(item))
      .provideEnvironment(r)
    def listFormsPaginated(
        request: zio.aws.amplifyuibuilder.model.ListFormsRequest
    ): IO[AwsError, zio.aws.amplifyuibuilder.model.ListFormsResponse.ReadOnly] =
      asyncRequestResponse[ListFormsRequest, ListFormsResponse](
        "listForms",
        api.listForms
      )(request.buildAwsValue())
        .map(zio.aws.amplifyuibuilder.model.ListFormsResponse.wrap)
        .provideEnvironment(r)
    def startCodegenJob(
        request: zio.aws.amplifyuibuilder.model.StartCodegenJobRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.StartCodegenJobResponse.ReadOnly
    ] = asyncRequestResponse[StartCodegenJobRequest, StartCodegenJobResponse](
      "startCodegenJob",
      api.startCodegenJob
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.StartCodegenJobResponse.wrap)
      .provideEnvironment(r)
    def listComponents(
        request: zio.aws.amplifyuibuilder.model.ListComponentsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListComponentsRequest,
      ComponentSummary,
      ListComponentsPublisher
    ]("listComponents", api.listComponentsPaginator, _.entities())(
      request.buildAwsValue()
    ).map(item => zio.aws.amplifyuibuilder.model.ComponentSummary.wrap(item))
      .provideEnvironment(r)
    def listComponentsPaginated(
        request: zio.aws.amplifyuibuilder.model.ListComponentsRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.ListComponentsResponse.ReadOnly
    ] = asyncRequestResponse[ListComponentsRequest, ListComponentsResponse](
      "listComponents",
      api.listComponents
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.ListComponentsResponse.wrap)
      .provideEnvironment(r)
    def refreshToken(
        request: zio.aws.amplifyuibuilder.model.RefreshTokenRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.RefreshTokenResponse.ReadOnly
    ] = asyncRequestResponse[RefreshTokenRequest, RefreshTokenResponse](
      "refreshToken",
      api.refreshToken
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.RefreshTokenResponse.wrap)
      .provideEnvironment(r)
    def updateForm(
        request: zio.aws.amplifyuibuilder.model.UpdateFormRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.UpdateFormResponse.ReadOnly
    ] = asyncRequestResponse[UpdateFormRequest, UpdateFormResponse](
      "updateForm",
      api.updateForm
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.UpdateFormResponse.wrap)
      .provideEnvironment(r)
    def getTheme(
        request: zio.aws.amplifyuibuilder.model.GetThemeRequest
    ): IO[AwsError, zio.aws.amplifyuibuilder.model.GetThemeResponse.ReadOnly] =
      asyncRequestResponse[GetThemeRequest, GetThemeResponse](
        "getTheme",
        api.getTheme
      )(request.buildAwsValue())
        .map(zio.aws.amplifyuibuilder.model.GetThemeResponse.wrap)
        .provideEnvironment(r)
    def createForm(
        request: zio.aws.amplifyuibuilder.model.CreateFormRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.CreateFormResponse.ReadOnly
    ] = asyncRequestResponse[CreateFormRequest, CreateFormResponse](
      "createForm",
      api.createForm
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.CreateFormResponse.wrap)
      .provideEnvironment(r)
    def deleteComponent(
        request: zio.aws.amplifyuibuilder.model.DeleteComponentRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteComponentRequest, DeleteComponentResponse](
        "deleteComponent",
        api.deleteComponent
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteForm(
        request: zio.aws.amplifyuibuilder.model.DeleteFormRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteFormRequest, DeleteFormResponse](
        "deleteForm",
        api.deleteForm
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createComponent(
        request: zio.aws.amplifyuibuilder.model.CreateComponentRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.CreateComponentResponse.ReadOnly
    ] = asyncRequestResponse[CreateComponentRequest, CreateComponentResponse](
      "createComponent",
      api.createComponent
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.CreateComponentResponse.wrap)
      .provideEnvironment(r)
    def exchangeCodeForToken(
        request: zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      ExchangeCodeForTokenRequest,
      ExchangeCodeForTokenResponse
    ]("exchangeCodeForToken", api.exchangeCodeForToken)(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.wrap)
      .provideEnvironment(r)
    def getCodegenJob(
        request: zio.aws.amplifyuibuilder.model.GetCodegenJobRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.GetCodegenJobResponse.ReadOnly
    ] = asyncRequestResponse[GetCodegenJobRequest, GetCodegenJobResponse](
      "getCodegenJob",
      api.getCodegenJob
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.GetCodegenJobResponse.wrap)
      .provideEnvironment(r)
    def getComponent(
        request: zio.aws.amplifyuibuilder.model.GetComponentRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.GetComponentResponse.ReadOnly
    ] = asyncRequestResponse[GetComponentRequest, GetComponentResponse](
      "getComponent",
      api.getComponent
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.GetComponentResponse.wrap)
      .provideEnvironment(r)
    def updateComponent(
        request: zio.aws.amplifyuibuilder.model.UpdateComponentRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.UpdateComponentResponse.ReadOnly
    ] = asyncRequestResponse[UpdateComponentRequest, UpdateComponentResponse](
      "updateComponent",
      api.updateComponent
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.UpdateComponentResponse.wrap)
      .provideEnvironment(r)
    def updateTheme(
        request: zio.aws.amplifyuibuilder.model.UpdateThemeRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.UpdateThemeResponse.ReadOnly
    ] = asyncRequestResponse[UpdateThemeRequest, UpdateThemeResponse](
      "updateTheme",
      api.updateTheme
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.UpdateThemeResponse.wrap)
      .provideEnvironment(r)
  }
  def getMetadata(
      request: zio.aws.amplifyuibuilder.model.GetMetadataRequest
  ): ZIO[zio.aws.amplifyuibuilder.AmplifyUiBuilder, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getMetadata(request))
  def exportThemes(
      request: zio.aws.amplifyuibuilder.model.ExportThemesRequest
  ): ZStream[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.Theme.ReadOnly
  ] = ZStream.serviceWithStream(_.exportThemes(request))
  def exportThemesPaginated(
      request: zio.aws.amplifyuibuilder.model.ExportThemesRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportThemesPaginated(request))
  def putMetadataFlag(
      request: zio.aws.amplifyuibuilder.model.PutMetadataFlagRequest
  ): ZIO[zio.aws.amplifyuibuilder.AmplifyUiBuilder, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putMetadataFlag(request))
  def exportComponents(
      request: zio.aws.amplifyuibuilder.model.ExportComponentsRequest
  ): ZStream[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.Component.ReadOnly
  ] = ZStream.serviceWithStream(_.exportComponents(request))
  def exportComponentsPaginated(
      request: zio.aws.amplifyuibuilder.model.ExportComponentsRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportComponentsPaginated(request))
  def deleteTheme(
      request: zio.aws.amplifyuibuilder.model.DeleteThemeRequest
  ): ZIO[zio.aws.amplifyuibuilder.AmplifyUiBuilder, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteTheme(request))
  def createTheme(
      request: zio.aws.amplifyuibuilder.model.CreateThemeRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.CreateThemeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTheme(request))
  def listThemes(
      request: zio.aws.amplifyuibuilder.model.ListThemesRequest
  ): ZStream[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listThemes(request))
  def listThemesPaginated(
      request: zio.aws.amplifyuibuilder.model.ListThemesRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ListThemesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listThemesPaginated(request))
  def getForm(request: zio.aws.amplifyuibuilder.model.GetFormRequest): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.GetFormResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getForm(request))
  def listCodegenJobs(
      request: zio.aws.amplifyuibuilder.model.ListCodegenJobsRequest
  ): ZStream[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.CodegenJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listCodegenJobs(request))
  def listCodegenJobsPaginated(
      request: zio.aws.amplifyuibuilder.model.ListCodegenJobsRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ListCodegenJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCodegenJobsPaginated(request))
  def exportForms(
      request: zio.aws.amplifyuibuilder.model.ExportFormsRequest
  ): ZStream[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.Form.ReadOnly
  ] = ZStream.serviceWithStream(_.exportForms(request))
  def exportFormsPaginated(
      request: zio.aws.amplifyuibuilder.model.ExportFormsRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ExportFormsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportFormsPaginated(request))
  def listForms(
      request: zio.aws.amplifyuibuilder.model.ListFormsRequest
  ): ZStream[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.FormSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listForms(request))
  def listFormsPaginated(
      request: zio.aws.amplifyuibuilder.model.ListFormsRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ListFormsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFormsPaginated(request))
  def startCodegenJob(
      request: zio.aws.amplifyuibuilder.model.StartCodegenJobRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.StartCodegenJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startCodegenJob(request))
  def listComponents(
      request: zio.aws.amplifyuibuilder.model.ListComponentsRequest
  ): ZStream[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listComponents(request))
  def listComponentsPaginated(
      request: zio.aws.amplifyuibuilder.model.ListComponentsRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ListComponentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComponentsPaginated(request))
  def refreshToken(
      request: zio.aws.amplifyuibuilder.model.RefreshTokenRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.RefreshTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.refreshToken(request))
  def updateForm(
      request: zio.aws.amplifyuibuilder.model.UpdateFormRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.UpdateFormResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateForm(request))
  def getTheme(request: zio.aws.amplifyuibuilder.model.GetThemeRequest): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.GetThemeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTheme(request))
  def createForm(
      request: zio.aws.amplifyuibuilder.model.CreateFormRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.CreateFormResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createForm(request))
  def deleteComponent(
      request: zio.aws.amplifyuibuilder.model.DeleteComponentRequest
  ): ZIO[zio.aws.amplifyuibuilder.AmplifyUiBuilder, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteComponent(request))
  def deleteForm(
      request: zio.aws.amplifyuibuilder.model.DeleteFormRequest
  ): ZIO[zio.aws.amplifyuibuilder.AmplifyUiBuilder, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteForm(request))
  def createComponent(
      request: zio.aws.amplifyuibuilder.model.CreateComponentRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.CreateComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createComponent(request))
  def exchangeCodeForToken(
      request: zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exchangeCodeForToken(request))
  def getCodegenJob(
      request: zio.aws.amplifyuibuilder.model.GetCodegenJobRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.GetCodegenJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCodegenJob(request))
  def getComponent(
      request: zio.aws.amplifyuibuilder.model.GetComponentRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.GetComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComponent(request))
  def updateComponent(
      request: zio.aws.amplifyuibuilder.model.UpdateComponentRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.UpdateComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateComponent(request))
  def updateTheme(
      request: zio.aws.amplifyuibuilder.model.UpdateThemeRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.UpdateThemeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTheme(request))
}
