package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFormsResponse(
    entities: Iterable[zio.aws.amplifyuibuilder.model.FormSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse = {
    import ListFormsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse
      .builder()
      .entities(entities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ListFormsResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.ListFormsResponse.wrap(buildAwsValue())
}
object ListFormsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ListFormsResponse =
      zio.aws.amplifyuibuilder.model.ListFormsResponse(
        entities.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def entities: List[zio.aws.amplifyuibuilder.model.FormSummary.ReadOnly]
    def nextToken: Optional[String]
    def getEntities: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.FormSummary.ReadOnly
    ]] = ZIO.succeed(entities)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse
  ) extends zio.aws.amplifyuibuilder.model.ListFormsResponse.ReadOnly {
    override val entities
        : List[zio.aws.amplifyuibuilder.model.FormSummary.ReadOnly] = impl
      .entities()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.FormSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse
  ): zio.aws.amplifyuibuilder.model.ListFormsResponse.ReadOnly = new Wrapper(
    impl
  )
}
