package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListCodegenJobsResponse(
    entities: Iterable[zio.aws.amplifyuibuilder.model.CodegenJobSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsResponse = {
    import ListCodegenJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsResponse
      .builder()
      .entities(entities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ListCodegenJobsResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.ListCodegenJobsResponse.wrap(buildAwsValue())
}
object ListCodegenJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ListCodegenJobsResponse =
      zio.aws.amplifyuibuilder.model.ListCodegenJobsResponse(
        entities.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def entities
        : List[zio.aws.amplifyuibuilder.model.CodegenJobSummary.ReadOnly]
    def nextToken: Optional[String]
    def getEntities: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.CodegenJobSummary.ReadOnly
    ]] = ZIO.succeed(entities)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsResponse
  ) extends zio.aws.amplifyuibuilder.model.ListCodegenJobsResponse.ReadOnly {
    override val entities
        : List[zio.aws.amplifyuibuilder.model.CodegenJobSummary.ReadOnly] = impl
      .entities()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.CodegenJobSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsResponse
  ): zio.aws.amplifyuibuilder.model.ListCodegenJobsResponse.ReadOnly =
    new Wrapper(impl)
}
