package zio.aws.amplifyuibuilder.model
import scala.jdk.CollectionConverters._
sealed trait JSScript {
  def unwrap: software.amazon.awssdk.services.amplifyuibuilder.model.JSScript
}
object JSScript {
  def wrap(
      value: software.amazon.awssdk.services.amplifyuibuilder.model.JSScript
  ): zio.aws.amplifyuibuilder.model.JSScript = value match {
    case software.amazon.awssdk.services.amplifyuibuilder.model.JSScript.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.JSScript.JSX =>
      val r = jsx
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.JSScript.TSX =>
      val r = tsx
      r
    case software.amazon.awssdk.services.amplifyuibuilder.model.JSScript.JS =>
      val r = js
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifyuibuilder.model.JSScript {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.JSScript =
      software.amazon.awssdk.services.amplifyuibuilder.model.JSScript.UNKNOWN_TO_SDK_VERSION
  }
  case object jsx extends zio.aws.amplifyuibuilder.model.JSScript {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.JSScript =
      software.amazon.awssdk.services.amplifyuibuilder.model.JSScript.JSX
  }
  case object tsx extends zio.aws.amplifyuibuilder.model.JSScript {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.JSScript =
      software.amazon.awssdk.services.amplifyuibuilder.model.JSScript.TSX
  }
  case object js extends zio.aws.amplifyuibuilder.model.JSScript {
    override def unwrap
        : software.amazon.awssdk.services.amplifyuibuilder.model.JSScript =
      software.amazon.awssdk.services.amplifyuibuilder.model.JSScript.JS
  }
}
