package zio.aws.amplifyuibuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.amplifyuibuilder.model.primitives.{ListCodegenJobsLimit, AppId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCodegenJobsRequest(
    appId: AppId,
    environmentName: String,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ListCodegenJobsLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsRequest = {
    import ListCodegenJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ListCodegenJobsLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ListCodegenJobsRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.ListCodegenJobsRequest.wrap(buildAwsValue())
}
object ListCodegenJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ListCodegenJobsRequest =
      zio.aws.amplifyuibuilder.model.ListCodegenJobsRequest(
        appId,
        environmentName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def appId: AppId
    def environmentName: String
    def nextToken: Optional[String]
    def maxResults: Optional[ListCodegenJobsLimit]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListCodegenJobsLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsRequest
  ) extends zio.aws.amplifyuibuilder.model.ListCodegenJobsRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplifyuibuilder.model.primitives.AppId(impl.appId())
    override val environmentName: String = impl.environmentName(): String
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ListCodegenJobsLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.amplifyuibuilder.model.primitives.ListCodegenJobsLimit(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListCodegenJobsRequest
  ): zio.aws.amplifyuibuilder.model.ListCodegenJobsRequest.ReadOnly =
    new Wrapper(impl)
}
