package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteComponentRequest(
    appId: String,
    environmentName: String,
    id: Uuid
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.DeleteComponentRequest = {
    import DeleteComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.DeleteComponentRequest
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.DeleteComponentRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.DeleteComponentRequest.wrap(buildAwsValue())
}
object DeleteComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.DeleteComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.DeleteComponentRequest =
      zio.aws.amplifyuibuilder.model
        .DeleteComponentRequest(appId, environmentName, id)
    def appId: String
    def environmentName: String
    def id: Uuid
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.DeleteComponentRequest
  ) extends zio.aws.amplifyuibuilder.model.DeleteComponentRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.DeleteComponentRequest
  ): zio.aws.amplifyuibuilder.model.DeleteComponentRequest.ReadOnly =
    new Wrapper(impl)
}
