package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComponentPropertyBindingProperties(
    property: String,
    field: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertyBindingProperties = {
    import ComponentPropertyBindingProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertyBindingProperties
      .builder()
      .property(property: java.lang.String)
      .optionallyWith(field.map(value => value: java.lang.String))(_.field)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties
      .wrap(buildAwsValue())
}
object ComponentPropertyBindingProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertyBindingProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties =
      zio.aws.amplifyuibuilder.model
        .ComponentPropertyBindingProperties(property, field.map(value => value))
    def property: String
    def field: Optional[String]
    def getProperty: ZIO[Any, Nothing, String] = ZIO.succeed(property)
    def getField: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("field", field)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertyBindingProperties
  ) extends zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly {
    override val property: String = impl.property(): String
    override val field: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.field())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertyBindingProperties
  ): zio.aws.amplifyuibuilder.model.ComponentPropertyBindingProperties.ReadOnly =
    new Wrapper(impl)
}
