package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActionParameters(
    `type`: Optional[zio.aws.amplifyuibuilder.model.ComponentProperty] =
      Optional.Absent,
    url: Optional[zio.aws.amplifyuibuilder.model.ComponentProperty] =
      Optional.Absent,
    anchor: Optional[zio.aws.amplifyuibuilder.model.ComponentProperty] =
      Optional.Absent,
    target: Optional[zio.aws.amplifyuibuilder.model.ComponentProperty] =
      Optional.Absent,
    global: Optional[zio.aws.amplifyuibuilder.model.ComponentProperty] =
      Optional.Absent,
    model: Optional[String] = Optional.Absent,
    id: Optional[zio.aws.amplifyuibuilder.model.ComponentProperty] =
      Optional.Absent,
    fields: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty]
    ] = Optional.Absent,
    state: Optional[
      zio.aws.amplifyuibuilder.model.MutationActionSetStateParameter
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ActionParameters = {
    import ActionParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ActionParameters
      .builder()
      .optionallyWith(`type`.map(value => value.buildAwsValue()))(_.`type`)
      .optionallyWith(url.map(value => value.buildAwsValue()))(_.url)
      .optionallyWith(anchor.map(value => value.buildAwsValue()))(_.anchor)
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .optionallyWith(global.map(value => value.buildAwsValue()))(_.global)
      .optionallyWith(model.map(value => value: java.lang.String))(_.model)
      .optionallyWith(id.map(value => value.buildAwsValue()))(_.id)
      .optionallyWith(
        fields.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.fields)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ActionParameters.ReadOnly =
    zio.aws.amplifyuibuilder.model.ActionParameters.wrap(buildAwsValue())
}
object ActionParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ActionParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ActionParameters =
      zio.aws.amplifyuibuilder.model.ActionParameters(
        `type`.map(value => value.asEditable),
        url.map(value => value.asEditable),
        anchor.map(value => value.asEditable),
        target.map(value => value.asEditable),
        global.map(value => value.asEditable),
        model.map(value => value),
        id.map(value => value.asEditable),
        fields.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        state.map(value => value.asEditable)
      )
    def `type`
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def url: Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def anchor
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def target
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def global
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def model: Optional[String]
    def id: Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def fields: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    ]
    def state: Optional[
      zio.aws.amplifyuibuilder.model.MutationActionSetStateParameter.ReadOnly
    ]
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = AwsError.unwrapOptionField("type", `type`)
    def getUrl: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = AwsError.unwrapOptionField("url", url)
    def getAnchor: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = AwsError.unwrapOptionField("anchor", anchor)
    def getTarget: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = AwsError.unwrapOptionField("target", target)
    def getGlobal: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = AwsError.unwrapOptionField("global", global)
    def getModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("model", model)
    def getId: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = AwsError.unwrapOptionField("id", id)
    def getFields: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("fields", fields)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.MutationActionSetStateParameter.ReadOnly
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ActionParameters
  ) extends zio.aws.amplifyuibuilder.model.ActionParameters.ReadOnly {
    override val `type`
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(value)
        )
    override val url
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.url())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(value)
        )
    override val anchor
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anchor())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(value)
        )
    override val target
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.target())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(value)
        )
    override val global
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.global())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(value)
        )
    override val model: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.model())
      .map(value => value: String)
    override val id
        : Optional[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(value)
        )
    override val fields: Optional[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fields())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentProperty
              .wrap(value)
          })
          .toMap
      )
    override val state: Optional[
      zio.aws.amplifyuibuilder.model.MutationActionSetStateParameter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value =>
        zio.aws.amplifyuibuilder.model.MutationActionSetStateParameter
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ActionParameters
  ): zio.aws.amplifyuibuilder.model.ActionParameters.ReadOnly = new Wrapper(
    impl
  )
}
