package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateThemeRequest(
    appId: String,
    clientToken: Optional[String] = Optional.Absent,
    environmentName: String,
    id: Uuid,
    updatedTheme: zio.aws.amplifyuibuilder.model.UpdateThemeData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeRequest = {
    import UpdateThemeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeRequest
      .builder()
      .appId(appId: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .updatedTheme(updatedTheme.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.UpdateThemeRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.UpdateThemeRequest.wrap(buildAwsValue())
}
object UpdateThemeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.UpdateThemeRequest =
      zio.aws.amplifyuibuilder.model.UpdateThemeRequest(
        appId,
        clientToken.map(value => value),
        environmentName,
        id,
        updatedTheme.asEditable
      )
    def appId: String
    def clientToken: Optional[String]
    def environmentName: String
    def id: Uuid
    def updatedTheme: zio.aws.amplifyuibuilder.model.UpdateThemeData.ReadOnly
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getUpdatedTheme: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.UpdateThemeData.ReadOnly
    ] = ZIO.succeed(updatedTheme)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeRequest
  ) extends zio.aws.amplifyuibuilder.model.UpdateThemeRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val updatedTheme
        : zio.aws.amplifyuibuilder.model.UpdateThemeData.ReadOnly =
      zio.aws.amplifyuibuilder.model.UpdateThemeData.wrap(impl.updatedTheme())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeRequest
  ): zio.aws.amplifyuibuilder.model.UpdateThemeRequest.ReadOnly = new Wrapper(
    impl
  )
}
