package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FormCTA(
    cancel: Optional[zio.aws.amplifyuibuilder.model.FormButton] =
      Optional.Absent,
    clear: Optional[zio.aws.amplifyuibuilder.model.FormButton] =
      Optional.Absent,
    position: Optional[zio.aws.amplifyuibuilder.model.FormButtonsPosition] =
      Optional.Absent,
    submit: Optional[zio.aws.amplifyuibuilder.model.FormButton] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FormCTA = {
    import FormCTA.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FormCTA
      .builder()
      .optionallyWith(cancel.map(value => value.buildAwsValue()))(_.cancel)
      .optionallyWith(clear.map(value => value.buildAwsValue()))(_.clear)
      .optionallyWith(position.map(value => value.unwrap))(_.position)
      .optionallyWith(submit.map(value => value.buildAwsValue()))(_.submit)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly =
    zio.aws.amplifyuibuilder.model.FormCTA.wrap(buildAwsValue())
}
object FormCTA {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FormCTA
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FormCTA =
      zio.aws.amplifyuibuilder.model.FormCTA(
        cancel.map(value => value.asEditable),
        clear.map(value => value.asEditable),
        position.map(value => value),
        submit.map(value => value.asEditable)
      )
    def cancel: Optional[zio.aws.amplifyuibuilder.model.FormButton.ReadOnly]
    def clear: Optional[zio.aws.amplifyuibuilder.model.FormButton.ReadOnly]
    def position: Optional[zio.aws.amplifyuibuilder.model.FormButtonsPosition]
    def submit: Optional[zio.aws.amplifyuibuilder.model.FormButton.ReadOnly]
    def getCancel: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormButton.ReadOnly
    ] = AwsError.unwrapOptionField("cancel", cancel)
    def getClear: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormButton.ReadOnly
    ] = AwsError.unwrapOptionField("clear", clear)
    def getPosition: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormButtonsPosition
    ] = AwsError.unwrapOptionField("position", position)
    def getSubmit: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.FormButton.ReadOnly
    ] = AwsError.unwrapOptionField("submit", submit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormCTA
  ) extends zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly {
    override val cancel
        : Optional[zio.aws.amplifyuibuilder.model.FormButton.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cancel())
        .map(value => zio.aws.amplifyuibuilder.model.FormButton.wrap(value))
    override val clear
        : Optional[zio.aws.amplifyuibuilder.model.FormButton.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clear())
        .map(value => zio.aws.amplifyuibuilder.model.FormButton.wrap(value))
    override val position
        : Optional[zio.aws.amplifyuibuilder.model.FormButtonsPosition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.position())
        .map(value =>
          zio.aws.amplifyuibuilder.model.FormButtonsPosition.wrap(value)
        )
    override val submit
        : Optional[zio.aws.amplifyuibuilder.model.FormButton.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.submit())
        .map(value => zio.aws.amplifyuibuilder.model.FormButton.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormCTA
  ): zio.aws.amplifyuibuilder.model.FormCTA.ReadOnly = new Wrapper(impl)
}
