package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExchangeCodeForTokenRequestBody(
    code: SensitiveString,
    redirectUri: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody = {
    import ExchangeCodeForTokenRequestBody.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody
      .builder()
      .code(SensitiveString.unwrap(code): java.lang.String)
      .redirectUri(redirectUri: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody.ReadOnly =
    zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody
      .wrap(buildAwsValue())
}
object ExchangeCodeForTokenRequestBody {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody =
      zio.aws.amplifyuibuilder.model
        .ExchangeCodeForTokenRequestBody(code, redirectUri)
    def code: SensitiveString
    def redirectUri: String
    def getCode: ZIO[Any, Nothing, SensitiveString] = ZIO.succeed(code)
    def getRedirectUri: ZIO[Any, Nothing, String] = ZIO.succeed(redirectUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody
  ) extends zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody.ReadOnly {
    override val code: SensitiveString =
      zio.aws.amplifyuibuilder.model.primitives.SensitiveString(impl.code())
    override val redirectUri: String = impl.redirectUri(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody
  ): zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequestBody.ReadOnly =
    new Wrapper(impl)
}
