package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RefreshTokenRequest(
    provider: zio.aws.amplifyuibuilder.model.TokenProviders,
    refreshTokenBody: zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequest = {
    import RefreshTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequest
      .builder()
      .provider(provider.unwrap)
      .refreshTokenBody(refreshTokenBody.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.RefreshTokenRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.RefreshTokenRequest.wrap(buildAwsValue())
}
object RefreshTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.RefreshTokenRequest =
      zio.aws.amplifyuibuilder.model
        .RefreshTokenRequest(provider, refreshTokenBody.asEditable)
    def provider: zio.aws.amplifyuibuilder.model.TokenProviders
    def refreshTokenBody
        : zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody.ReadOnly
    def getProvider
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.TokenProviders] =
      ZIO.succeed(provider)
    def getRefreshTokenBody: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody.ReadOnly
    ] = ZIO.succeed(refreshTokenBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequest
  ) extends zio.aws.amplifyuibuilder.model.RefreshTokenRequest.ReadOnly {
    override val provider: zio.aws.amplifyuibuilder.model.TokenProviders =
      zio.aws.amplifyuibuilder.model.TokenProviders.wrap(impl.provider())
    override val refreshTokenBody
        : zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody.ReadOnly =
      zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody
        .wrap(impl.refreshTokenBody())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequest
  ): zio.aws.amplifyuibuilder.model.RefreshTokenRequest.ReadOnly = new Wrapper(
    impl
  )
}
