package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FieldInputConfig(
    defaultChecked: Optional[Boolean] = Optional.Absent,
    defaultCountryCode: Optional[String] = Optional.Absent,
    defaultValue: Optional[String] = Optional.Absent,
    descriptiveText: Optional[String] = Optional.Absent,
    isArray: Optional[Boolean] = Optional.Absent,
    maxValue: Optional[Float] = Optional.Absent,
    minValue: Optional[Float] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    placeholder: Optional[String] = Optional.Absent,
    readOnly: Optional[Boolean] = Optional.Absent,
    required: Optional[Boolean] = Optional.Absent,
    step: Optional[Float] = Optional.Absent,
    `type`: String,
    value: Optional[String] = Optional.Absent,
    valueMappings: Optional[zio.aws.amplifyuibuilder.model.ValueMappings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FieldInputConfig = {
    import FieldInputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FieldInputConfig
      .builder()
      .optionallyWith(defaultChecked.map(value => value: java.lang.Boolean))(
        _.defaultChecked
      )
      .optionallyWith(defaultCountryCode.map(value => value: java.lang.String))(
        _.defaultCountryCode
      )
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(descriptiveText.map(value => value: java.lang.String))(
        _.descriptiveText
      )
      .optionallyWith(isArray.map(value => value: java.lang.Boolean))(_.isArray)
      .optionallyWith(maxValue.map(value => value: java.lang.Float))(_.maxValue)
      .optionallyWith(minValue.map(value => value: java.lang.Float))(_.minValue)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(placeholder.map(value => value: java.lang.String))(
        _.placeholder
      )
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .optionallyWith(required.map(value => value: java.lang.Boolean))(
        _.required
      )
      .optionallyWith(step.map(value => value: java.lang.Float))(_.step)
      .`type`(`type`: java.lang.String)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(valueMappings.map(value => value.buildAwsValue()))(
        _.valueMappings
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.FieldInputConfig.ReadOnly =
    zio.aws.amplifyuibuilder.model.FieldInputConfig.wrap(buildAwsValue())
}
object FieldInputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FieldInputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FieldInputConfig =
      zio.aws.amplifyuibuilder.model.FieldInputConfig(
        defaultChecked.map(value => value),
        defaultCountryCode.map(value => value),
        defaultValue.map(value => value),
        descriptiveText.map(value => value),
        isArray.map(value => value),
        maxValue.map(value => value),
        minValue.map(value => value),
        name.map(value => value),
        placeholder.map(value => value),
        readOnly.map(value => value),
        required.map(value => value),
        step.map(value => value),
        `type`,
        value.map(value => value),
        valueMappings.map(value => value.asEditable)
      )
    def defaultChecked: Optional[Boolean]
    def defaultCountryCode: Optional[String]
    def defaultValue: Optional[String]
    def descriptiveText: Optional[String]
    def isArray: Optional[Boolean]
    def maxValue: Optional[Float]
    def minValue: Optional[Float]
    def name: Optional[String]
    def placeholder: Optional[String]
    def readOnly: Optional[Boolean]
    def required: Optional[Boolean]
    def step: Optional[Float]
    def `type`: String
    def value: Optional[String]
    def valueMappings
        : Optional[zio.aws.amplifyuibuilder.model.ValueMappings.ReadOnly]
    def getDefaultChecked: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultChecked", defaultChecked)
    def getDefaultCountryCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultCountryCode", defaultCountryCode)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDescriptiveText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("descriptiveText", descriptiveText)
    def getIsArray: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isArray", isArray)
    def getMaxValue: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("maxValue", maxValue)
    def getMinValue: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("minValue", minValue)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getPlaceholder: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("placeholder", placeholder)
    def getReadOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("required", required)
    def getStep: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("step", step)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getValueMappings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ValueMappings.ReadOnly
    ] = AwsError.unwrapOptionField("valueMappings", valueMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FieldInputConfig
  ) extends zio.aws.amplifyuibuilder.model.FieldInputConfig.ReadOnly {
    override val defaultChecked: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultChecked())
      .map(value => value: Boolean)
    override val defaultCountryCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultCountryCode())
      .map(value => value: String)
    override val defaultValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => value: String)
    override val descriptiveText: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.descriptiveText())
      .map(value => value: String)
    override val isArray: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isArray())
      .map(value => value: Boolean)
    override val maxValue: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.maxValue())
      .map(value => value: Float)
    override val minValue: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.minValue())
      .map(value => value: Float)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val placeholder: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.placeholder())
      .map(value => value: String)
    override val readOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.readOnly())
      .map(value => value: Boolean)
    override val required: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.required())
      .map(value => value: Boolean)
    override val step: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.step())
      .map(value => value: Float)
    override val `type`: String = impl.`type`(): String
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val valueMappings
        : Optional[zio.aws.amplifyuibuilder.model.ValueMappings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.valueMappings())
        .map(value => zio.aws.amplifyuibuilder.model.ValueMappings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FieldInputConfig
  ): zio.aws.amplifyuibuilder.model.FieldInputConfig.ReadOnly = new Wrapper(
    impl
  )
}
