package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FormDataTypeConfig(
    dataSourceType: zio.aws.amplifyuibuilder.model.FormDataSourceType,
    dataTypeName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FormDataTypeConfig = {
    import FormDataTypeConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FormDataTypeConfig
      .builder()
      .dataSourceType(dataSourceType.unwrap)
      .dataTypeName(dataTypeName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly =
    zio.aws.amplifyuibuilder.model.FormDataTypeConfig.wrap(buildAwsValue())
}
object FormDataTypeConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FormDataTypeConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FormDataTypeConfig =
      zio.aws.amplifyuibuilder.model
        .FormDataTypeConfig(dataSourceType, dataTypeName)
    def dataSourceType: zio.aws.amplifyuibuilder.model.FormDataSourceType
    def dataTypeName: String
    def getDataSourceType
        : ZIO[Any, Nothing, zio.aws.amplifyuibuilder.model.FormDataSourceType] =
      ZIO.succeed(dataSourceType)
    def getDataTypeName: ZIO[Any, Nothing, String] = ZIO.succeed(dataTypeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormDataTypeConfig
  ) extends zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly {
    override val dataSourceType
        : zio.aws.amplifyuibuilder.model.FormDataSourceType =
      zio.aws.amplifyuibuilder.model.FormDataSourceType
        .wrap(impl.dataSourceType())
    override val dataTypeName: String = impl.dataTypeName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormDataTypeConfig
  ): zio.aws.amplifyuibuilder.model.FormDataTypeConfig.ReadOnly = new Wrapper(
    impl
  )
}
