package zio.aws.amplifyuibuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.amplifyuibuilder.model.primitives.ListComponentsLimit
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListComponentsRequest(
    appId: String,
    environmentName: String,
    maxResults: Optional[ListComponentsLimit] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest = {
    import ListComponentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest
      .builder()
      .appId(appId: java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .optionallyWith(
        maxResults.map(value => ListComponentsLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ListComponentsRequest.ReadOnly =
    zio.aws.amplifyuibuilder.model.ListComponentsRequest.wrap(buildAwsValue())
}
object ListComponentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ListComponentsRequest =
      zio.aws.amplifyuibuilder.model.ListComponentsRequest(
        appId,
        environmentName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def appId: String
    def environmentName: String
    def maxResults: Optional[ListComponentsLimit]
    def nextToken: Optional[String]
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getMaxResults: ZIO[Any, AwsError, ListComponentsLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest
  ) extends zio.aws.amplifyuibuilder.model.ListComponentsRequest.ReadOnly {
    override val appId: String = impl.appId(): String
    override val environmentName: String = impl.environmentName(): String
    override val maxResults: Optional[ListComponentsLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.amplifyuibuilder.model.primitives.ListComponentsLimit(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest
  ): zio.aws.amplifyuibuilder.model.ListComponentsRequest.ReadOnly =
    new Wrapper(impl)
}
