package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FormStyleConfig(
    tokenReference: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.FormStyleConfig = {
    import FormStyleConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.FormStyleConfig
      .builder()
      .optionallyWith(tokenReference.map(value => value: java.lang.String))(
        _.tokenReference
      )
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.FormStyleConfig.ReadOnly =
    zio.aws.amplifyuibuilder.model.FormStyleConfig.wrap(buildAwsValue())
}
object FormStyleConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.FormStyleConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.FormStyleConfig =
      zio.aws.amplifyuibuilder.model.FormStyleConfig(
        tokenReference.map(value => value),
        value.map(value => value)
      )
    def tokenReference: Optional[String]
    def value: Optional[String]
    def getTokenReference: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tokenReference", tokenReference)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormStyleConfig
  ) extends zio.aws.amplifyuibuilder.model.FormStyleConfig.ReadOnly {
    override val tokenReference: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenReference())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.FormStyleConfig
  ): zio.aws.amplifyuibuilder.model.FormStyleConfig.ReadOnly = new Wrapper(impl)
}
