package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{
  ComponentName,
  Uuid,
  ComponentType
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ComponentSummary(
    appId: String,
    componentType: ComponentType,
    environmentName: String,
    id: Uuid,
    name: ComponentName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentSummary = {
    import ComponentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentSummary
      .builder()
      .appId(appId: java.lang.String)
      .componentType(ComponentType.unwrap(componentType): java.lang.String)
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .name(ComponentName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentSummary.wrap(buildAwsValue())
}
object ComponentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ComponentSummary =
      zio.aws.amplifyuibuilder.model.ComponentSummary(
        appId,
        componentType,
        environmentName,
        id,
        name
      )
    def appId: String
    def componentType: ComponentType
    def environmentName: String
    def id: Uuid
    def name: ComponentName
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getComponentType: ZIO[Any, Nothing, ComponentType] =
      ZIO.succeed(componentType)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, ComponentName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentSummary
  ) extends zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly {
    override val appId: String = impl.appId(): String
    override val componentType: ComponentType =
      zio.aws.amplifyuibuilder.model.primitives
        .ComponentType(impl.componentType())
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val name: ComponentName =
      zio.aws.amplifyuibuilder.model.primitives.ComponentName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentSummary
  ): zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly = new Wrapper(
    impl
  )
}
