package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ComponentConditionProperty(
    elseValue: Option[zio.aws.amplifyuibuilder.model.ComponentProperty] = None,
    field: Option[String] = None,
    operand: Option[String] = None,
    operandType: Option[String] = None,
    operator: Option[String] = None,
    property: Option[String] = None,
    then: Option[zio.aws.amplifyuibuilder.model.ComponentProperty] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty = {
    import ComponentConditionProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty
      .builder()
      .optionallyWith(elseValue.map(value => value.buildAwsValue()))(
        _.elseValue
      )
      .optionallyWith(field.map(value => value: java.lang.String))(_.field)
      .optionallyWith(operand.map(value => value: java.lang.String))(_.operand)
      .optionallyWith(operandType.map(value => value: java.lang.String))(
        _.operandType
      )
      .optionallyWith(operator.map(value => value: java.lang.String))(
        _.operator
      )
      .optionallyWith(property.map(value => value: java.lang.String))(
        _.property
      )
      .optionallyWith(then.map(value => value.buildAwsValue()))(_.then)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentConditionProperty
      .wrap(buildAwsValue())
}
object ComponentConditionProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ComponentConditionProperty =
      zio.aws.amplifyuibuilder.model.ComponentConditionProperty(
        elseValue.map(value => value.asEditable),
        field.map(value => value),
        operand.map(value => value),
        operandType.map(value => value),
        operator.map(value => value),
        property.map(value => value),
        then.map(value => value.asEditable)
      )
    def elseValue
        : Option[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def field: Option[String]
    def operand: Option[String]
    def operandType: Option[String]
    def operator: Option[String]
    def property: Option[String]
    def then: Option[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def getElseValue: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = AwsError.unwrapOptionField("elseValue", elseValue)
    def getField: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("field", field)
    def getOperand: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operand", operand)
    def getOperandType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operandType", operandType)
    def getOperator: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operator", operator)
    def getProperty: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("property", property)
    def getThen: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = AwsError.unwrapOptionField("then", then)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty
  ) extends zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly {
    override val elseValue
        : Option[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly] =
      scala
        .Option(impl.elseValue())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(value)
        )
    override val field: Option[String] =
      scala.Option(impl.field()).map(value => value: String)
    override val operand: Option[String] =
      scala.Option(impl.operand()).map(value => value: String)
    override val operandType: Option[String] =
      scala.Option(impl.operandType()).map(value => value: String)
    override val operator: Option[String] =
      scala.Option(impl.operator()).map(value => value: String)
    override val property: Option[String] =
      scala.Option(impl.property()).map(value => value: String)
    override val then
        : Option[zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly] =
      scala
        .Option(impl.then())
        .map(value =>
          zio.aws.amplifyuibuilder.model.ComponentProperty.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentConditionProperty
  ): zio.aws.amplifyuibuilder.model.ComponentConditionProperty.ReadOnly =
    new Wrapper(impl)
}
