package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{ThemeName, Uuid}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateThemeData(
    id: Option[Uuid] = None,
    name: Option[ThemeName] = None,
    overrides: Option[Iterable[zio.aws.amplifyuibuilder.model.ThemeValues]] =
      None,
    values: Iterable[zio.aws.amplifyuibuilder.model.ThemeValues]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeData = {
    import UpdateThemeData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeData
      .builder()
      .optionallyWith(id.map(value => Uuid.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => ThemeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .values(values.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.UpdateThemeData.ReadOnly =
    zio.aws.amplifyuibuilder.model.UpdateThemeData.wrap(buildAwsValue())
}
object UpdateThemeData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.UpdateThemeData =
      zio.aws.amplifyuibuilder.model.UpdateThemeData(
        id.map(value => value),
        name.map(value => value),
        overrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        values.map { item =>
          item.asEditable
        }
      )
    def id: Option[Uuid]
    def name: Option[ThemeName]
    def overrides
        : Option[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]]
    def values: List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]
    def getId: ZIO[Any, AwsError, Uuid] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ThemeName] =
      AwsError.unwrapOptionField("name", name)
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
    def getValues: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly
    ]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeData
  ) extends zio.aws.amplifyuibuilder.model.UpdateThemeData.ReadOnly {
    override val id: Option[Uuid] = scala
      .Option(impl.id())
      .map(value => zio.aws.amplifyuibuilder.model.primitives.Uuid(value))
    override val name: Option[ThemeName] = scala
      .Option(impl.name())
      .map(value => zio.aws.amplifyuibuilder.model.primitives.ThemeName(value))
    override val overrides
        : Option[List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly]] =
      scala
        .Option(impl.overrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
          }.toList
        )
    override val values
        : List[zio.aws.amplifyuibuilder.model.ThemeValues.ReadOnly] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.ThemeValues.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeData
  ): zio.aws.amplifyuibuilder.model.UpdateThemeData.ReadOnly = new Wrapper(impl)
}
