package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.{
  ComponentName,
  SyntheticTimestamp_date_time,
  TagValue,
  Uuid,
  ComponentType,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Component(
    appId: String,
    bindingProperties: Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue
    ],
    children: Option[Iterable[zio.aws.amplifyuibuilder.model.ComponentChild]] =
      None,
    collectionProperties: Option[
      Map[String, zio.aws.amplifyuibuilder.model.ComponentDataConfiguration]
    ] = None,
    componentType: ComponentType,
    createdAt: SyntheticTimestamp_date_time,
    environmentName: String,
    id: Uuid,
    modifiedAt: Option[SyntheticTimestamp_date_time] = None,
    name: ComponentName,
    overrides: Map[String, Map[String, String]],
    properties: Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty],
    sourceId: Option[String] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    variants: Iterable[zio.aws.amplifyuibuilder.model.ComponentVariant]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.Component = {
    import Component.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.Component
      .builder()
      .appId(appId: java.lang.String)
      .bindingProperties(
        bindingProperties
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(
        children.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.children)
      .optionallyWith(
        collectionProperties.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.collectionProperties)
      .componentType(ComponentType.unwrap(componentType): java.lang.String)
      .createdAt(SyntheticTimestamp_date_time.unwrap(createdAt): Instant)
      .environmentName(environmentName: java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .optionallyWith(
        modifiedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.modifiedAt)
      .name(ComponentName.unwrap(name): java.lang.String)
      .overrides(
        overrides
          .map({ case (key, value) =>
            (key: java.lang.String) -> value
              .map({ case (key, value) =>
                (key: java.lang.String) -> (value: java.lang.String)
              })
              .asJava
          })
          .asJava
      )
      .properties(
        properties
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(sourceId.map(value => value: java.lang.String))(
        _.sourceId
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .variants(variants.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.Component.ReadOnly =
    zio.aws.amplifyuibuilder.model.Component.wrap(buildAwsValue())
}
object Component {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.Component
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.Component =
      zio.aws.amplifyuibuilder.model.Component(
        appId,
        bindingProperties.map({ case (key, value) =>
          key -> value.asEditable
        }),
        children.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        collectionProperties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        componentType,
        createdAt,
        environmentName,
        id,
        modifiedAt.map(value => value),
        name,
        overrides,
        properties.map({ case (key, value) =>
          key -> value.asEditable
        }),
        sourceId.map(value => value),
        tags.map(value => value),
        variants.map { item =>
          item.asEditable
        }
      )
    def appId: String
    def bindingProperties: Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ]
    def children
        : Option[List[zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly]]
    def collectionProperties: Option[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]]
    def componentType: ComponentType
    def createdAt: SyntheticTimestamp_date_time
    def environmentName: String
    def id: Uuid
    def modifiedAt: Option[SyntheticTimestamp_date_time]
    def name: ComponentName
    def overrides: Map[String, Map[String, String]]
    def properties
        : Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def sourceId: Option[String]
    def tags: Option[Map[TagKey, TagValue]]
    def variants: List[zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly]
    def getAppId: ZIO[Any, Nothing, String] = ZIO.succeed(appId)
    def getBindingProperties: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ]] = ZIO.succeed(bindingProperties)
    def getChildren: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly
    ]] = AwsError.unwrapOptionField("children", children)
    def getCollectionProperties: ZIO[Any, AwsError, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("collectionProperties", collectionProperties)
    def getComponentType: ZIO[Any, Nothing, ComponentType] =
      ZIO.succeed(componentType)
    def getCreatedAt: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(createdAt)
    def getEnvironmentName: ZIO[Any, Nothing, String] =
      ZIO.succeed(environmentName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getModifiedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("modifiedAt", modifiedAt)
    def getName: ZIO[Any, Nothing, ComponentName] = ZIO.succeed(name)
    def getOverrides: ZIO[Any, Nothing, Map[String, Map[String, String]]] =
      ZIO.succeed(overrides)
    def getProperties: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ]] = ZIO.succeed(properties)
    def getSourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVariants: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly
    ]] = ZIO.succeed(variants)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Component
  ) extends zio.aws.amplifyuibuilder.model.Component.ReadOnly {
    override val appId: String = impl.appId(): String
    override val bindingProperties: Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue.ReadOnly
    ] = impl
      .bindingProperties()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.ComponentBindingPropertiesValue
          .wrap(value)
      })
      .toMap
    override val children
        : Option[List[zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly]] =
      scala
        .Option(impl.children())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.ComponentChild.wrap(item)
          }.toList
        )
    override val collectionProperties: Option[Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly
    ]] = scala
      .Option(impl.collectionProperties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.amplifyuibuilder.model.ComponentDataConfiguration
              .wrap(value)
          })
          .toMap
      )
    override val componentType: ComponentType =
      zio.aws.amplifyuibuilder.model.primitives
        .ComponentType(impl.componentType())
    override val createdAt: SyntheticTimestamp_date_time =
      zio.aws.amplifyuibuilder.model.primitives
        .SyntheticTimestamp_date_time(impl.createdAt())
    override val environmentName: String = impl.environmentName(): String
    override val id: Uuid =
      zio.aws.amplifyuibuilder.model.primitives.Uuid(impl.id())
    override val modifiedAt: Option[SyntheticTimestamp_date_time] = scala
      .Option(impl.modifiedAt())
      .map(value =>
        zio.aws.amplifyuibuilder.model.primitives
          .SyntheticTimestamp_date_time(value)
      )
    override val name: ComponentName =
      zio.aws.amplifyuibuilder.model.primitives.ComponentName(impl.name())
    override val overrides: Map[String, Map[String, String]] = impl
      .overrides()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      })
      .toMap
    override val properties: Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = impl
      .properties()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.ComponentProperty
          .wrap(value)
      })
      .toMap
    override val sourceId: Option[String] =
      scala.Option(impl.sourceId()).map(value => value: String)
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplifyuibuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.amplifyuibuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val variants
        : List[zio.aws.amplifyuibuilder.model.ComponentVariant.ReadOnly] = impl
      .variants()
      .asScala
      .map { item =>
        zio.aws.amplifyuibuilder.model.ComponentVariant.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.Component
  ): zio.aws.amplifyuibuilder.model.Component.ReadOnly = new Wrapper(impl)
}
