package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExportThemesResponse(
    entities: Iterable[zio.aws.amplifyuibuilder.model.Theme]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse = {
    import ExportThemesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse
      .builder()
      .entities(entities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.ExportThemesResponse.wrap(buildAwsValue())
}
object ExportThemesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ExportThemesResponse =
      zio.aws.amplifyuibuilder.model.ExportThemesResponse(entities.map { item =>
        item.asEditable
      })
    def entities: List[zio.aws.amplifyuibuilder.model.Theme.ReadOnly]
    def getEntities: ZIO[Any, Nothing, List[
      zio.aws.amplifyuibuilder.model.Theme.ReadOnly
    ]] = ZIO.succeed(entities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse
  ) extends zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly {
    override val entities: List[zio.aws.amplifyuibuilder.model.Theme.ReadOnly] =
      impl
        .entities()
        .asScala
        .map { item =>
          zio.aws.amplifyuibuilder.model.Theme.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse
  ): zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly = new Wrapper(
    impl
  )
}
