package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ComponentDataConfiguration(
    identifiers: Option[Iterable[String]] = None,
    model: String,
    predicate: Option[zio.aws.amplifyuibuilder.model.Predicate] = None,
    sort: Option[Iterable[zio.aws.amplifyuibuilder.model.SortProperty]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentDataConfiguration = {
    import ComponentDataConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentDataConfiguration
      .builder()
      .optionallyWith(
        identifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.identifiers)
      .model(model: java.lang.String)
      .optionallyWith(predicate.map(value => value.buildAwsValue()))(
        _.predicate
      )
      .optionallyWith(
        sort.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sort)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentDataConfiguration
      .wrap(buildAwsValue())
}
object ComponentDataConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentDataConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ComponentDataConfiguration =
      zio.aws.amplifyuibuilder.model.ComponentDataConfiguration(
        identifiers.map(value => value),
        model,
        predicate.map(value => value.asEditable),
        sort.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def identifiers: Option[List[String]]
    def model: String
    def predicate: Option[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly]
    def sort: Option[List[zio.aws.amplifyuibuilder.model.SortProperty.ReadOnly]]
    def getIdentifiers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("identifiers", identifiers)
    def getModel: ZIO[Any, Nothing, String] = ZIO.succeed(model)
    def getPredicate: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.Predicate.ReadOnly
    ] = AwsError.unwrapOptionField("predicate", predicate)
    def getSort: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.SortProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("sort", sort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentDataConfiguration
  ) extends zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly {
    override val identifiers: Option[List[String]] = scala
      .Option(impl.identifiers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val model: String = impl.model(): String
    override val predicate
        : Option[zio.aws.amplifyuibuilder.model.Predicate.ReadOnly] = scala
      .Option(impl.predicate())
      .map(value => zio.aws.amplifyuibuilder.model.Predicate.wrap(value))
    override val sort
        : Option[List[zio.aws.amplifyuibuilder.model.SortProperty.ReadOnly]] =
      scala
        .Option(impl.sort())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.SortProperty.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentDataConfiguration
  ): zio.aws.amplifyuibuilder.model.ComponentDataConfiguration.ReadOnly =
    new Wrapper(impl)
}
