package zio.aws.amplifyuibuilder.model
import zio.aws.amplifyuibuilder.model.primitives.SyntheticRefreshTokenRequestBodyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RefreshTokenRequestBody(
    token: SyntheticRefreshTokenRequestBodyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequestBody = {
    import RefreshTokenRequestBody.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequestBody
      .builder()
      .token(
        SyntheticRefreshTokenRequestBodyString.unwrap(token): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody.ReadOnly =
    zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody.wrap(buildAwsValue())
}
object RefreshTokenRequestBody {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequestBody
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody =
      zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody(token)
    def token: SyntheticRefreshTokenRequestBodyString
    def getToken: ZIO[Any, Nothing, SyntheticRefreshTokenRequestBodyString] =
      ZIO.succeed(token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequestBody
  ) extends zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody.ReadOnly {
    override val token: SyntheticRefreshTokenRequestBodyString =
      zio.aws.amplifyuibuilder.model.primitives
        .SyntheticRefreshTokenRequestBodyString(impl.token())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequestBody
  ): zio.aws.amplifyuibuilder.model.RefreshTokenRequestBody.ReadOnly =
    new Wrapper(impl)
}
