package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetComponentResponse(
    component: Option[zio.aws.amplifyuibuilder.model.Component] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentResponse = {
    import GetComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentResponse
      .builder()
      .optionallyWith(component.map(value => value.buildAwsValue()))(
        _.component
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.GetComponentResponse.ReadOnly =
    zio.aws.amplifyuibuilder.model.GetComponentResponse.wrap(buildAwsValue())
}
object GetComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.GetComponentResponse =
      zio.aws.amplifyuibuilder.model
        .GetComponentResponse(component.map(value => value.asEditable))
    def component: Option[zio.aws.amplifyuibuilder.model.Component.ReadOnly]
    def getComponent: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.Component.ReadOnly
    ] = AwsError.unwrapOptionField("component", component)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentResponse
  ) extends zio.aws.amplifyuibuilder.model.GetComponentResponse.ReadOnly {
    override val component
        : Option[zio.aws.amplifyuibuilder.model.Component.ReadOnly] = scala
      .Option(impl.component())
      .map(value => zio.aws.amplifyuibuilder.model.Component.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentResponse
  ): zio.aws.amplifyuibuilder.model.GetComponentResponse.ReadOnly = new Wrapper(
    impl
  )
}
