package zio.aws.amplifyuibuilder
import zio.aws.amplifyuibuilder.model.CreateThemeResponse.ReadOnly
import software.amazon.awssdk.services.amplifyuibuilder.model.{
  CreateComponentResponse,
  UpdateComponentResponse,
  ListThemesRequest,
  ExportThemesRequest,
  DeleteThemeResponse,
  ListThemesResponse,
  ExportComponentsRequest,
  ThemeSummary,
  GetThemeResponse,
  DeleteComponentRequest,
  DeleteComponentResponse,
  GetComponentResponse,
  ComponentSummary,
  CreateComponentRequest,
  UpdateThemeResponse,
  RefreshTokenRequest,
  ExchangeCodeForTokenResponse,
  GetThemeRequest,
  DeleteThemeRequest,
  ExportThemesResponse,
  ExchangeCodeForTokenRequest,
  ExportComponentsResponse,
  UpdateComponentRequest,
  CreateThemeResponse,
  RefreshTokenResponse,
  ListComponentsRequest,
  CreateThemeRequest,
  UpdateThemeRequest,
  ListComponentsResponse,
  GetComponentRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.amplifyuibuilder.{
  AmplifyUiBuilderAsyncClientBuilder,
  AmplifyUiBuilderAsyncClient
}
import zio.stream.ZStream
import software.amazon.awssdk.services.amplifyuibuilder.paginators.{
  ListComponentsPublisher,
  ListThemesPublisher
}
import scala.jdk.CollectionConverters._
trait AmplifyUiBuilder extends AspectSupport[AmplifyUiBuilder] {
  val api: AmplifyUiBuilderAsyncClient
  def exportThemes(
      request: zio.aws.amplifyuibuilder.model.ExportThemesRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly]
  def exportComponents(
      request: zio.aws.amplifyuibuilder.model.ExportComponentsRequest
  ): IO[
    AwsError,
    zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly
  ]
  def deleteTheme(
      request: zio.aws.amplifyuibuilder.model.DeleteThemeRequest
  ): IO[AwsError, Unit]
  def createTheme(
      request: zio.aws.amplifyuibuilder.model.CreateThemeRequest
  ): IO[AwsError, ReadOnly]
  def listThemes(
      request: zio.aws.amplifyuibuilder.model.ListThemesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly
  ]
  def listThemesPaginated(
      request: zio.aws.amplifyuibuilder.model.ListThemesRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.ListThemesResponse.ReadOnly]
  def listComponents(
      request: zio.aws.amplifyuibuilder.model.ListComponentsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly
  ]
  def listComponentsPaginated(
      request: zio.aws.amplifyuibuilder.model.ListComponentsRequest
  ): IO[
    AwsError,
    zio.aws.amplifyuibuilder.model.ListComponentsResponse.ReadOnly
  ]
  def refreshToken(
      request: zio.aws.amplifyuibuilder.model.RefreshTokenRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.RefreshTokenResponse.ReadOnly]
  def getTheme(
      request: zio.aws.amplifyuibuilder.model.GetThemeRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.GetThemeResponse.ReadOnly]
  def deleteComponent(
      request: zio.aws.amplifyuibuilder.model.DeleteComponentRequest
  ): IO[AwsError, Unit]
  def createComponent(
      request: zio.aws.amplifyuibuilder.model.CreateComponentRequest
  ): IO[
    AwsError,
    zio.aws.amplifyuibuilder.model.CreateComponentResponse.ReadOnly
  ]
  def exchangeCodeForToken(
      request: zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequest
  ): IO[
    AwsError,
    zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly
  ]
  def getComponent(
      request: zio.aws.amplifyuibuilder.model.GetComponentRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.GetComponentResponse.ReadOnly]
  def updateComponent(
      request: zio.aws.amplifyuibuilder.model.UpdateComponentRequest
  ): IO[
    AwsError,
    zio.aws.amplifyuibuilder.model.UpdateComponentResponse.ReadOnly
  ]
  def updateTheme(
      request: zio.aws.amplifyuibuilder.model.UpdateThemeRequest
  ): IO[AwsError, zio.aws.amplifyuibuilder.model.UpdateThemeResponse.ReadOnly]
}
object AmplifyUiBuilder {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AmplifyUiBuilder] =
    customized(identity)
  def customized(
      customization: AmplifyUiBuilderAsyncClientBuilder => AmplifyUiBuilderAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AmplifyUiBuilder] = managed(
    customization
  ).toLayer
  def managed(
      customization: AmplifyUiBuilderAsyncClientBuilder => AmplifyUiBuilderAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, AmplifyUiBuilder] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = AmplifyUiBuilderAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        AmplifyUiBuilderAsyncClient,
        AmplifyUiBuilderAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        AmplifyUiBuilderAsyncClient,
        AmplifyUiBuilderAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new AmplifyUiBuilderImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class AmplifyUiBuilderImpl[R](
      override val api: AmplifyUiBuilderAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AmplifyUiBuilder
      with AwsServiceBase[R] {
    override val serviceName: String = "AmplifyUiBuilder"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AmplifyUiBuilderImpl[R1] = new AmplifyUiBuilderImpl(api, newAspect, r)
    def exportThemes(
        request: zio.aws.amplifyuibuilder.model.ExportThemesRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly
    ] = asyncRequestResponse[ExportThemesRequest, ExportThemesResponse](
      "exportThemes",
      api.exportThemes
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.ExportThemesResponse.wrap)
      .provideEnvironment(r)
    def exportComponents(
        request: zio.aws.amplifyuibuilder.model.ExportComponentsRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly
    ] = asyncRequestResponse[ExportComponentsRequest, ExportComponentsResponse](
      "exportComponents",
      api.exportComponents
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.ExportComponentsResponse.wrap)
      .provideEnvironment(r)
    def deleteTheme(
        request: zio.aws.amplifyuibuilder.model.DeleteThemeRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteThemeRequest, DeleteThemeResponse](
        "deleteTheme",
        api.deleteTheme
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createTheme(
        request: zio.aws.amplifyuibuilder.model.CreateThemeRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[CreateThemeRequest, CreateThemeResponse](
        "createTheme",
        api.createTheme
      )(request.buildAwsValue())
        .map(zio.aws.amplifyuibuilder.model.CreateThemeResponse.wrap)
        .provideEnvironment(r)
    def listThemes(
        request: zio.aws.amplifyuibuilder.model.ListThemesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListThemesRequest,
      ThemeSummary,
      ListThemesPublisher
    ]("listThemes", api.listThemesPaginator, _.entities())(
      request.buildAwsValue()
    ).map(item => zio.aws.amplifyuibuilder.model.ThemeSummary.wrap(item))
      .provideEnvironment(r)
    def listThemesPaginated(
        request: zio.aws.amplifyuibuilder.model.ListThemesRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.ListThemesResponse.ReadOnly
    ] = asyncRequestResponse[ListThemesRequest, ListThemesResponse](
      "listThemes",
      api.listThemes
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.ListThemesResponse.wrap)
      .provideEnvironment(r)
    def listComponents(
        request: zio.aws.amplifyuibuilder.model.ListComponentsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListComponentsRequest,
      ComponentSummary,
      ListComponentsPublisher
    ]("listComponents", api.listComponentsPaginator, _.entities())(
      request.buildAwsValue()
    ).map(item => zio.aws.amplifyuibuilder.model.ComponentSummary.wrap(item))
      .provideEnvironment(r)
    def listComponentsPaginated(
        request: zio.aws.amplifyuibuilder.model.ListComponentsRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.ListComponentsResponse.ReadOnly
    ] = asyncRequestResponse[ListComponentsRequest, ListComponentsResponse](
      "listComponents",
      api.listComponents
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.ListComponentsResponse.wrap)
      .provideEnvironment(r)
    def refreshToken(
        request: zio.aws.amplifyuibuilder.model.RefreshTokenRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.RefreshTokenResponse.ReadOnly
    ] = asyncRequestResponse[RefreshTokenRequest, RefreshTokenResponse](
      "refreshToken",
      api.refreshToken
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.RefreshTokenResponse.wrap)
      .provideEnvironment(r)
    def getTheme(
        request: zio.aws.amplifyuibuilder.model.GetThemeRequest
    ): IO[AwsError, zio.aws.amplifyuibuilder.model.GetThemeResponse.ReadOnly] =
      asyncRequestResponse[GetThemeRequest, GetThemeResponse](
        "getTheme",
        api.getTheme
      )(request.buildAwsValue())
        .map(zio.aws.amplifyuibuilder.model.GetThemeResponse.wrap)
        .provideEnvironment(r)
    def deleteComponent(
        request: zio.aws.amplifyuibuilder.model.DeleteComponentRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteComponentRequest, DeleteComponentResponse](
        "deleteComponent",
        api.deleteComponent
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createComponent(
        request: zio.aws.amplifyuibuilder.model.CreateComponentRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.CreateComponentResponse.ReadOnly
    ] = asyncRequestResponse[CreateComponentRequest, CreateComponentResponse](
      "createComponent",
      api.createComponent
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.CreateComponentResponse.wrap)
      .provideEnvironment(r)
    def exchangeCodeForToken(
        request: zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      ExchangeCodeForTokenRequest,
      ExchangeCodeForTokenResponse
    ]("exchangeCodeForToken", api.exchangeCodeForToken)(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.wrap)
      .provideEnvironment(r)
    def getComponent(
        request: zio.aws.amplifyuibuilder.model.GetComponentRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.GetComponentResponse.ReadOnly
    ] = asyncRequestResponse[GetComponentRequest, GetComponentResponse](
      "getComponent",
      api.getComponent
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.GetComponentResponse.wrap)
      .provideEnvironment(r)
    def updateComponent(
        request: zio.aws.amplifyuibuilder.model.UpdateComponentRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.UpdateComponentResponse.ReadOnly
    ] = asyncRequestResponse[UpdateComponentRequest, UpdateComponentResponse](
      "updateComponent",
      api.updateComponent
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.UpdateComponentResponse.wrap)
      .provideEnvironment(r)
    def updateTheme(
        request: zio.aws.amplifyuibuilder.model.UpdateThemeRequest
    ): IO[
      AwsError,
      zio.aws.amplifyuibuilder.model.UpdateThemeResponse.ReadOnly
    ] = asyncRequestResponse[UpdateThemeRequest, UpdateThemeResponse](
      "updateTheme",
      api.updateTheme
    )(request.buildAwsValue())
      .map(zio.aws.amplifyuibuilder.model.UpdateThemeResponse.wrap)
      .provideEnvironment(r)
  }
  def exportThemes(
      request: zio.aws.amplifyuibuilder.model.ExportThemesRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ExportThemesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportThemes(request))
  def exportComponents(
      request: zio.aws.amplifyuibuilder.model.ExportComponentsRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ExportComponentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportComponents(request))
  def deleteTheme(
      request: zio.aws.amplifyuibuilder.model.DeleteThemeRequest
  ): ZIO[zio.aws.amplifyuibuilder.AmplifyUiBuilder, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteTheme(request))
  def createTheme(
      request: zio.aws.amplifyuibuilder.model.CreateThemeRequest
  ): ZIO[zio.aws.amplifyuibuilder.AmplifyUiBuilder, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createTheme(request))
  def listThemes(
      request: zio.aws.amplifyuibuilder.model.ListThemesRequest
  ): ZStream[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ThemeSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listThemes(request))
  def listThemesPaginated(
      request: zio.aws.amplifyuibuilder.model.ListThemesRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ListThemesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listThemesPaginated(request))
  def listComponents(
      request: zio.aws.amplifyuibuilder.model.ListComponentsRequest
  ): ZStream[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ComponentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listComponents(request))
  def listComponentsPaginated(
      request: zio.aws.amplifyuibuilder.model.ListComponentsRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ListComponentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComponentsPaginated(request))
  def refreshToken(
      request: zio.aws.amplifyuibuilder.model.RefreshTokenRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.RefreshTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.refreshToken(request))
  def getTheme(request: zio.aws.amplifyuibuilder.model.GetThemeRequest): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.GetThemeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTheme(request))
  def deleteComponent(
      request: zio.aws.amplifyuibuilder.model.DeleteComponentRequest
  ): ZIO[zio.aws.amplifyuibuilder.AmplifyUiBuilder, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteComponent(request))
  def createComponent(
      request: zio.aws.amplifyuibuilder.model.CreateComponentRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.CreateComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createComponent(request))
  def exchangeCodeForToken(
      request: zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.ExchangeCodeForTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exchangeCodeForToken(request))
  def getComponent(
      request: zio.aws.amplifyuibuilder.model.GetComponentRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.GetComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComponent(request))
  def updateComponent(
      request: zio.aws.amplifyuibuilder.model.UpdateComponentRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.UpdateComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateComponent(request))
  def updateTheme(
      request: zio.aws.amplifyuibuilder.model.UpdateThemeRequest
  ): ZIO[
    zio.aws.amplifyuibuilder.AmplifyUiBuilder,
    AwsError,
    zio.aws.amplifyuibuilder.model.UpdateThemeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTheme(request))
}
