package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ComponentChild(
    children: Option[Iterable[zio.aws.amplifyuibuilder.model.ComponentChild]] =
      None,
    componentType: String,
    name: String,
    properties: Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild = {
    import ComponentChild.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild
      .builder()
      .optionallyWith(
        children.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.children)
      .componentType(componentType: java.lang.String)
      .name(name: java.lang.String)
      .properties(
        properties
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly =
    zio.aws.amplifyuibuilder.model.ComponentChild.wrap(buildAwsValue())
}
object ComponentChild {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.ComponentChild =
      zio.aws.amplifyuibuilder.model.ComponentChild(
        children.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        componentType,
        name,
        properties.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def children
        : Option[List[zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly]]
    def componentType: String
    def name: String
    def properties
        : Map[String, zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly]
    def getChildren: ZIO[Any, AwsError, List[
      zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly
    ]] = AwsError.unwrapOptionField("children", children)
    def getComponentType: ZIO[Any, Nothing, String] = ZIO.succeed(componentType)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getProperties: ZIO[Any, Nothing, Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ]] = ZIO.succeed(properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild
  ) extends zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly {
    override val children
        : Option[List[zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly]] =
      scala
        .Option(impl.children())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifyuibuilder.model.ComponentChild.wrap(item)
          }.toList
        )
    override val componentType: String = impl.componentType(): String
    override val name: String = impl.name(): String
    override val properties: Map[
      String,
      zio.aws.amplifyuibuilder.model.ComponentProperty.ReadOnly
    ] = impl
      .properties()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.amplifyuibuilder.model.ComponentProperty
          .wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild
  ): zio.aws.amplifyuibuilder.model.ComponentChild.ReadOnly = new Wrapper(impl)
}
