package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateBackendAuthResourceConfig(
    authResources: zio.aws.amplifybackend.model.AuthResources,
    identityPoolConfigs: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig
    ] = Optional.Absent,
    service: zio.aws.amplifybackend.model.Service,
    userPoolConfigs: zio.aws.amplifybackend.model.UpdateBackendAuthUserPoolConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResourceConfig = {
    import UpdateBackendAuthResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResourceConfig
      .builder()
      .authResources(authResources.unwrap)
      .optionallyWith(identityPoolConfigs.map(value => value.buildAwsValue()))(
        _.identityPoolConfigs
      )
      .service(service.unwrap)
      .userPoolConfigs(userPoolConfigs.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendAuthResourceConfig.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendAuthResourceConfig
      .wrap(buildAwsValue())
}
object UpdateBackendAuthResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.UpdateBackendAuthResourceConfig =
      zio.aws.amplifybackend.model.UpdateBackendAuthResourceConfig(
        authResources,
        identityPoolConfigs.map(value => value.asEditable),
        service,
        userPoolConfigs.asEditable
      )
    def authResources: zio.aws.amplifybackend.model.AuthResources
    def identityPoolConfigs: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig.ReadOnly
    ]
    def service: zio.aws.amplifybackend.model.Service
    def userPoolConfigs
        : zio.aws.amplifybackend.model.UpdateBackendAuthUserPoolConfig.ReadOnly
    def getAuthResources
        : ZIO[Any, Nothing, zio.aws.amplifybackend.model.AuthResources] =
      ZIO.succeed(authResources)
    def getIdentityPoolConfigs: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig.ReadOnly
    ] = AwsError.unwrapOptionField("identityPoolConfigs", identityPoolConfigs)
    def getService: ZIO[Any, Nothing, zio.aws.amplifybackend.model.Service] =
      ZIO.succeed(service)
    def getUserPoolConfigs: ZIO[
      Any,
      Nothing,
      zio.aws.amplifybackend.model.UpdateBackendAuthUserPoolConfig.ReadOnly
    ] = ZIO.succeed(userPoolConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResourceConfig
  ) extends zio.aws.amplifybackend.model.UpdateBackendAuthResourceConfig.ReadOnly {
    override val authResources: zio.aws.amplifybackend.model.AuthResources =
      zio.aws.amplifybackend.model.AuthResources.wrap(impl.authResources())
    override val identityPoolConfigs: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.identityPoolConfigs())
      .map(value =>
        zio.aws.amplifybackend.model.UpdateBackendAuthIdentityPoolConfig
          .wrap(value)
      )
    override val service: zio.aws.amplifybackend.model.Service =
      zio.aws.amplifybackend.model.Service.wrap(impl.service())
    override val userPoolConfigs
        : zio.aws.amplifybackend.model.UpdateBackendAuthUserPoolConfig.ReadOnly =
      zio.aws.amplifybackend.model.UpdateBackendAuthUserPoolConfig
        .wrap(impl.userPoolConfigs())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResourceConfig
  ): zio.aws.amplifybackend.model.UpdateBackendAuthResourceConfig.ReadOnly =
    new Wrapper(impl)
}
