package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateBackendAuthOAuthConfig(
    domainPrefix: Optional[__string] = Optional.Absent,
    oAuthGrantType: zio.aws.amplifybackend.model.OAuthGrantType,
    oAuthScopes: Iterable[zio.aws.amplifybackend.model.OAuthScopesElement],
    redirectSignInURIs: Iterable[__string],
    redirectSignOutURIs: Iterable[__string],
    socialProviderSettings: Optional[
      zio.aws.amplifybackend.model.SocialProviderSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthOAuthConfig = {
    import CreateBackendAuthOAuthConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthOAuthConfig
      .builder()
      .optionallyWith(domainPrefix.map(value => value: java.lang.String))(
        _.domainPrefix
      )
      .oAuthGrantType(oAuthGrantType.unwrap)
      .oAuthScopesWithStrings(oAuthScopes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .redirectSignInURIs(redirectSignInURIs.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .redirectSignOutURIs(redirectSignOutURIs.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        socialProviderSettings.map(value => value.buildAwsValue())
      )(_.socialProviderSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.CreateBackendAuthOAuthConfig.ReadOnly =
    zio.aws.amplifybackend.model.CreateBackendAuthOAuthConfig
      .wrap(buildAwsValue())
}
object CreateBackendAuthOAuthConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthOAuthConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.CreateBackendAuthOAuthConfig =
      zio.aws.amplifybackend.model.CreateBackendAuthOAuthConfig(
        domainPrefix.map(value => value),
        oAuthGrantType,
        oAuthScopes,
        redirectSignInURIs,
        redirectSignOutURIs,
        socialProviderSettings.map(value => value.asEditable)
      )
    def domainPrefix: Optional[__string]
    def oAuthGrantType: zio.aws.amplifybackend.model.OAuthGrantType
    def oAuthScopes: List[zio.aws.amplifybackend.model.OAuthScopesElement]
    def redirectSignInURIs: List[__string]
    def redirectSignOutURIs: List[__string]
    def socialProviderSettings
        : Optional[zio.aws.amplifybackend.model.SocialProviderSettings.ReadOnly]
    def getDomainPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("domainPrefix", domainPrefix)
    def getOAuthGrantType
        : ZIO[Any, Nothing, zio.aws.amplifybackend.model.OAuthGrantType] =
      ZIO.succeed(oAuthGrantType)
    def getOAuthScopes: ZIO[Any, Nothing, List[
      zio.aws.amplifybackend.model.OAuthScopesElement
    ]] = ZIO.succeed(oAuthScopes)
    def getRedirectSignInURIs: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(redirectSignInURIs)
    def getRedirectSignOutURIs: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(redirectSignOutURIs)
    def getSocialProviderSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.SocialProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "socialProviderSettings",
      socialProviderSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthOAuthConfig
  ) extends zio.aws.amplifybackend.model.CreateBackendAuthOAuthConfig.ReadOnly {
    override val domainPrefix: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.domainPrefix())
      .map(value => value: __string)
    override val oAuthGrantType: zio.aws.amplifybackend.model.OAuthGrantType =
      zio.aws.amplifybackend.model.OAuthGrantType.wrap(impl.oAuthGrantType())
    override val oAuthScopes
        : List[zio.aws.amplifybackend.model.OAuthScopesElement] = impl
      .oAuthScopes()
      .asScala
      .map { item =>
        zio.aws.amplifybackend.model.OAuthScopesElement.wrap(item)
      }
      .toList
    override val redirectSignInURIs: List[__string] = impl
      .redirectSignInURIs()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val redirectSignOutURIs: List[__string] = impl
      .redirectSignOutURIs()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val socialProviderSettings: Optional[
      zio.aws.amplifybackend.model.SocialProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.socialProviderSettings())
      .map(value =>
        zio.aws.amplifybackend.model.SocialProviderSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthOAuthConfig
  ): zio.aws.amplifybackend.model.CreateBackendAuthOAuthConfig.ReadOnly =
    new Wrapper(impl)
}
