package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateBackendAuthVerificationMessageConfig(
    deliveryMethod: zio.aws.amplifybackend.model.DeliveryMethod,
    emailSettings: Optional[zio.aws.amplifybackend.model.EmailSettings] =
      Optional.Absent,
    smsSettings: Optional[zio.aws.amplifybackend.model.SmsSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthVerificationMessageConfig = {
    import CreateBackendAuthVerificationMessageConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthVerificationMessageConfig
      .builder()
      .deliveryMethod(deliveryMethod.unwrap)
      .optionallyWith(emailSettings.map(value => value.buildAwsValue()))(
        _.emailSettings
      )
      .optionallyWith(smsSettings.map(value => value.buildAwsValue()))(
        _.smsSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.CreateBackendAuthVerificationMessageConfig.ReadOnly =
    zio.aws.amplifybackend.model.CreateBackendAuthVerificationMessageConfig
      .wrap(buildAwsValue())
}
object CreateBackendAuthVerificationMessageConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthVerificationMessageConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.CreateBackendAuthVerificationMessageConfig =
      zio.aws.amplifybackend.model.CreateBackendAuthVerificationMessageConfig(
        deliveryMethod,
        emailSettings.map(value => value.asEditable),
        smsSettings.map(value => value.asEditable)
      )
    def deliveryMethod: zio.aws.amplifybackend.model.DeliveryMethod
    def emailSettings
        : Optional[zio.aws.amplifybackend.model.EmailSettings.ReadOnly]
    def smsSettings: Optional[zio.aws.amplifybackend.model.SmsSettings.ReadOnly]
    def getDeliveryMethod
        : ZIO[Any, Nothing, zio.aws.amplifybackend.model.DeliveryMethod] =
      ZIO.succeed(deliveryMethod)
    def getEmailSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.EmailSettings.ReadOnly
    ] = AwsError.unwrapOptionField("emailSettings", emailSettings)
    def getSmsSettings: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.SmsSettings.ReadOnly
    ] = AwsError.unwrapOptionField("smsSettings", smsSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthVerificationMessageConfig
  ) extends zio.aws.amplifybackend.model.CreateBackendAuthVerificationMessageConfig.ReadOnly {
    override val deliveryMethod: zio.aws.amplifybackend.model.DeliveryMethod =
      zio.aws.amplifybackend.model.DeliveryMethod.wrap(impl.deliveryMethod())
    override val emailSettings
        : Optional[zio.aws.amplifybackend.model.EmailSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailSettings())
        .map(value => zio.aws.amplifybackend.model.EmailSettings.wrap(value))
    override val smsSettings
        : Optional[zio.aws.amplifybackend.model.SmsSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smsSettings())
        .map(value => zio.aws.amplifybackend.model.SmsSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthVerificationMessageConfig
  ): zio.aws.amplifybackend.model.CreateBackendAuthVerificationMessageConfig.ReadOnly =
    new Wrapper(impl)
}
