package zio.aws.amplifybackend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateBackendAuthUserPoolConfig(
    forgotPassword: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig
    ] = Optional.Absent,
    mfa: Optional[zio.aws.amplifybackend.model.UpdateBackendAuthMFAConfig] =
      Optional.Absent,
    oAuth: Optional[zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig] =
      Optional.Absent,
    passwordPolicy: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig
    ] = Optional.Absent,
    verificationMessage: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthUserPoolConfig = {
    import UpdateBackendAuthUserPoolConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthUserPoolConfig
      .builder()
      .optionallyWith(forgotPassword.map(value => value.buildAwsValue()))(
        _.forgotPassword
      )
      .optionallyWith(mfa.map(value => value.buildAwsValue()))(_.mfa)
      .optionallyWith(oAuth.map(value => value.buildAwsValue()))(_.oAuth)
      .optionallyWith(passwordPolicy.map(value => value.buildAwsValue()))(
        _.passwordPolicy
      )
      .optionallyWith(verificationMessage.map(value => value.buildAwsValue()))(
        _.verificationMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendAuthUserPoolConfig.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendAuthUserPoolConfig
      .wrap(buildAwsValue())
}
object UpdateBackendAuthUserPoolConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthUserPoolConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.amplifybackend.model.UpdateBackendAuthUserPoolConfig =
      zio.aws.amplifybackend.model.UpdateBackendAuthUserPoolConfig(
        forgotPassword.map(value => value.asEditable),
        mfa.map(value => value.asEditable),
        oAuth.map(value => value.asEditable),
        passwordPolicy.map(value => value.asEditable),
        verificationMessage.map(value => value.asEditable)
      )
    def forgotPassword: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig.ReadOnly
    ]
    def mfa: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthMFAConfig.ReadOnly
    ]
    def oAuth: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig.ReadOnly
    ]
    def passwordPolicy: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig.ReadOnly
    ]
    def verificationMessage: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig.ReadOnly
    ]
    def getForgotPassword: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig.ReadOnly
    ] = AwsError.unwrapOptionField("forgotPassword", forgotPassword)
    def getMfa: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.UpdateBackendAuthMFAConfig.ReadOnly
    ] = AwsError.unwrapOptionField("mfa", mfa)
    def getOAuth: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig.ReadOnly
    ] = AwsError.unwrapOptionField("oAuth", oAuth)
    def getPasswordPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig.ReadOnly
    ] = AwsError.unwrapOptionField("passwordPolicy", passwordPolicy)
    def getVerificationMessage: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig.ReadOnly
    ] = AwsError.unwrapOptionField("verificationMessage", verificationMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthUserPoolConfig
  ) extends zio.aws.amplifybackend.model.UpdateBackendAuthUserPoolConfig.ReadOnly {
    override val forgotPassword: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.forgotPassword())
      .map(value =>
        zio.aws.amplifybackend.model.UpdateBackendAuthForgotPasswordConfig
          .wrap(value)
      )
    override val mfa: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthMFAConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mfa())
      .map(value =>
        zio.aws.amplifybackend.model.UpdateBackendAuthMFAConfig.wrap(value)
      )
    override val oAuth: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.oAuth())
      .map(value =>
        zio.aws.amplifybackend.model.UpdateBackendAuthOAuthConfig.wrap(value)
      )
    override val passwordPolicy: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.passwordPolicy())
      .map(value =>
        zio.aws.amplifybackend.model.UpdateBackendAuthPasswordPolicyConfig
          .wrap(value)
      )
    override val verificationMessage: Optional[
      zio.aws.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.verificationMessage())
      .map(value =>
        zio.aws.amplifybackend.model.UpdateBackendAuthVerificationMessageConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthUserPoolConfig
  ): zio.aws.amplifybackend.model.UpdateBackendAuthUserPoolConfig.ReadOnly =
    new Wrapper(impl)
}
