package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteBackendStorageResponse(
    appId: Optional[__string] = Optional.Absent,
    backendEnvironmentName: Optional[__string] = Optional.Absent,
    jobId: Optional[__string] = Optional.Absent,
    status: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageResponse = {
    import DeleteBackendStorageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageResponse
      .builder()
      .optionallyWith(appId.map(value => value: java.lang.String))(_.appId)
      .optionallyWith(
        backendEnvironmentName.map(value => value: java.lang.String)
      )(_.backendEnvironmentName)
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.DeleteBackendStorageResponse.ReadOnly =
    zio.aws.amplifybackend.model.DeleteBackendStorageResponse
      .wrap(buildAwsValue())
}
object DeleteBackendStorageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.DeleteBackendStorageResponse =
      zio.aws.amplifybackend.model.DeleteBackendStorageResponse(
        appId.map(value => value),
        backendEnvironmentName.map(value => value),
        jobId.map(value => value),
        status.map(value => value)
      )
    def appId: Optional[__string]
    def backendEnvironmentName: Optional[__string]
    def jobId: Optional[__string]
    def status: Optional[__string]
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getBackendEnvironmentName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("backendEnvironmentName", backendEnvironmentName)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageResponse
  ) extends zio.aws.amplifybackend.model.DeleteBackendStorageResponse.ReadOnly {
    override val appId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => value: __string)
    override val backendEnvironmentName: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backendEnvironmentName())
        .map(value => value: __string)
    override val jobId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => value: __string)
    override val status: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageResponse
  ): zio.aws.amplifybackend.model.DeleteBackendStorageResponse.ReadOnly =
    new Wrapper(impl)
}
