package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListS3BucketsResponse(
    buckets: Optional[Iterable[zio.aws.amplifybackend.model.S3BucketInfo]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsResponse = {
    import ListS3BucketsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsResponse
      .builder()
      .optionallyWith(
        buckets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buckets)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.ListS3BucketsResponse.ReadOnly =
    zio.aws.amplifybackend.model.ListS3BucketsResponse.wrap(buildAwsValue())
}
object ListS3BucketsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.ListS3BucketsResponse =
      zio.aws.amplifybackend.model.ListS3BucketsResponse(
        buckets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def buckets
        : Optional[List[zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly]]
    def nextToken: Optional[__string]
    def getBuckets: ZIO[Any, AwsError, List[
      zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("buckets", buckets)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsResponse
  ) extends zio.aws.amplifybackend.model.ListS3BucketsResponse.ReadOnly {
    override val buckets
        : Optional[List[zio.aws.amplifybackend.model.S3BucketInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buckets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplifybackend.model.S3BucketInfo.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsResponse
  ): zio.aws.amplifybackend.model.ListS3BucketsResponse.ReadOnly = new Wrapper(
    impl
  )
}
