package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetBackendJobResponse(
    appId: Optional[__string] = Optional.Absent,
    backendEnvironmentName: Optional[__string] = Optional.Absent,
    createTime: Optional[__string] = Optional.Absent,
    error: Optional[__string] = Optional.Absent,
    jobId: Optional[__string] = Optional.Absent,
    operation: Optional[__string] = Optional.Absent,
    status: Optional[__string] = Optional.Absent,
    updateTime: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.GetBackendJobResponse = {
    import GetBackendJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.GetBackendJobResponse
      .builder()
      .optionallyWith(appId.map(value => value: java.lang.String))(_.appId)
      .optionallyWith(
        backendEnvironmentName.map(value => value: java.lang.String)
      )(_.backendEnvironmentName)
      .optionallyWith(createTime.map(value => value: java.lang.String))(
        _.createTime
      )
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(operation.map(value => value: java.lang.String))(
        _.operation
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(updateTime.map(value => value: java.lang.String))(
        _.updateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.GetBackendJobResponse.ReadOnly =
    zio.aws.amplifybackend.model.GetBackendJobResponse.wrap(buildAwsValue())
}
object GetBackendJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.GetBackendJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.GetBackendJobResponse =
      zio.aws.amplifybackend.model.GetBackendJobResponse(
        appId.map(value => value),
        backendEnvironmentName.map(value => value),
        createTime.map(value => value),
        error.map(value => value),
        jobId.map(value => value),
        operation.map(value => value),
        status.map(value => value),
        updateTime.map(value => value)
      )
    def appId: Optional[__string]
    def backendEnvironmentName: Optional[__string]
    def createTime: Optional[__string]
    def error: Optional[__string]
    def jobId: Optional[__string]
    def operation: Optional[__string]
    def status: Optional[__string]
    def updateTime: Optional[__string]
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getBackendEnvironmentName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("backendEnvironmentName", backendEnvironmentName)
    def getCreateTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getError: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("error", error)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getOperation: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("operation", operation)
    def getStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("status", status)
    def getUpdateTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("updateTime", updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendJobResponse
  ) extends zio.aws.amplifybackend.model.GetBackendJobResponse.ReadOnly {
    override val appId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => value: __string)
    override val backendEnvironmentName: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backendEnvironmentName())
        .map(value => value: __string)
    override val createTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => value: __string)
    override val error: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => value: __string)
    override val jobId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => value: __string)
    override val operation: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.operation())
      .map(value => value: __string)
    override val status: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: __string)
    override val updateTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.updateTime())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendJobResponse
  ): zio.aws.amplifybackend.model.GetBackendJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
