package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateBackendAuthRequest(
    appId: __string,
    backendEnvironmentName: __string,
    resourceConfig: zio.aws.amplifybackend.model.UpdateBackendAuthResourceConfig,
    resourceName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthRequest = {
    import UpdateBackendAuthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthRequest
      .builder()
      .appId(appId: java.lang.String)
      .backendEnvironmentName(backendEnvironmentName: java.lang.String)
      .resourceConfig(resourceConfig.buildAwsValue())
      .resourceName(resourceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendAuthRequest.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendAuthRequest.wrap(buildAwsValue())
}
object UpdateBackendAuthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.UpdateBackendAuthRequest =
      zio.aws.amplifybackend.model.UpdateBackendAuthRequest(
        appId,
        backendEnvironmentName,
        resourceConfig.asEditable,
        resourceName
      )
    def appId: __string
    def backendEnvironmentName: __string
    def resourceConfig
        : zio.aws.amplifybackend.model.UpdateBackendAuthResourceConfig.ReadOnly
    def resourceName: __string
    def getAppId: ZIO[Any, Nothing, __string] = ZIO.succeed(appId)
    def getBackendEnvironmentName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(backendEnvironmentName)
    def getResourceConfig: ZIO[
      Any,
      Nothing,
      zio.aws.amplifybackend.model.UpdateBackendAuthResourceConfig.ReadOnly
    ] = ZIO.succeed(resourceConfig)
    def getResourceName: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthRequest
  ) extends zio.aws.amplifybackend.model.UpdateBackendAuthRequest.ReadOnly {
    override val appId: __string = impl.appId(): __string
    override val backendEnvironmentName: __string =
      impl.backendEnvironmentName(): __string
    override val resourceConfig
        : zio.aws.amplifybackend.model.UpdateBackendAuthResourceConfig.ReadOnly =
      zio.aws.amplifybackend.model.UpdateBackendAuthResourceConfig
        .wrap(impl.resourceConfig())
    override val resourceName: __string = impl.resourceName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthRequest
  ): zio.aws.amplifybackend.model.UpdateBackendAuthRequest.ReadOnly =
    new Wrapper(impl)
}
