package zio.aws.amplifybackend.model
import scala.jdk.CollectionConverters.*
sealed trait Service {
  def unwrap: software.amazon.awssdk.services.amplifybackend.model.Service
}
object Service {
  def wrap(
      value: software.amazon.awssdk.services.amplifybackend.model.Service
  ): zio.aws.amplifybackend.model.Service = value match {
    case software.amazon.awssdk.services.amplifybackend.model.Service.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifybackend.model.Service.COGNITO =>
      val r = COGNITO
      r
  }
  case object unknownToSdkVersion extends zio.aws.amplifybackend.model.Service {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.Service =
      software.amazon.awssdk.services.amplifybackend.model.Service.UNKNOWN_TO_SDK_VERSION
  }
  case object COGNITO extends zio.aws.amplifybackend.model.Service {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.Service =
      software.amazon.awssdk.services.amplifybackend.model.Service.COGNITO
  }
}
