package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateBackendConfigResponse(
    appId: Optional[__string] = Optional.Absent,
    backendManagerAppId: Optional[__string] = Optional.Absent,
    error: Optional[__string] = Optional.Absent,
    loginAuthConfig: Optional[
      zio.aws.amplifybackend.model.LoginAuthConfigReqObj
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse = {
    import UpdateBackendConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse
      .builder()
      .optionallyWith(appId.map(value => value: java.lang.String))(_.appId)
      .optionallyWith(
        backendManagerAppId.map(value => value: java.lang.String)
      )(_.backendManagerAppId)
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .optionallyWith(loginAuthConfig.map(value => value.buildAwsValue()))(
        _.loginAuthConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifybackend.model.UpdateBackendConfigResponse.ReadOnly =
    zio.aws.amplifybackend.model.UpdateBackendConfigResponse
      .wrap(buildAwsValue())
}
object UpdateBackendConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.UpdateBackendConfigResponse =
      zio.aws.amplifybackend.model.UpdateBackendConfigResponse(
        appId.map(value => value),
        backendManagerAppId.map(value => value),
        error.map(value => value),
        loginAuthConfig.map(value => value.asEditable)
      )
    def appId: Optional[__string]
    def backendManagerAppId: Optional[__string]
    def error: Optional[__string]
    def loginAuthConfig
        : Optional[zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly]
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getBackendManagerAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("backendManagerAppId", backendManagerAppId)
    def getError: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("error", error)
    def getLoginAuthConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly
    ] = AwsError.unwrapOptionField("loginAuthConfig", loginAuthConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse
  ) extends zio.aws.amplifybackend.model.UpdateBackendConfigResponse.ReadOnly {
    override val appId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => value: __string)
    override val backendManagerAppId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.backendManagerAppId())
      .map(value => value: __string)
    override val error: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => value: __string)
    override val loginAuthConfig: Optional[
      zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loginAuthConfig())
      .map(value =>
        zio.aws.amplifybackend.model.LoginAuthConfigReqObj.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse
  ): zio.aws.amplifybackend.model.UpdateBackendConfigResponse.ReadOnly =
    new Wrapper(impl)
}
