package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LoginAuthConfigReqObj(
    awsCognitoIdentityPoolId: Optional[__string] = Optional.Absent,
    awsCognitoRegion: Optional[__string] = Optional.Absent,
    awsUserPoolsId: Optional[__string] = Optional.Absent,
    awsUserPoolsWebClientId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.LoginAuthConfigReqObj = {
    import LoginAuthConfigReqObj.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.LoginAuthConfigReqObj
      .builder()
      .optionallyWith(
        awsCognitoIdentityPoolId.map(value => value: java.lang.String)
      )(_.awsCognitoIdentityPoolId)
      .optionallyWith(awsCognitoRegion.map(value => value: java.lang.String))(
        _.awsCognitoRegion
      )
      .optionallyWith(awsUserPoolsId.map(value => value: java.lang.String))(
        _.awsUserPoolsId
      )
      .optionallyWith(
        awsUserPoolsWebClientId.map(value => value: java.lang.String)
      )(_.awsUserPoolsWebClientId)
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly =
    zio.aws.amplifybackend.model.LoginAuthConfigReqObj.wrap(buildAwsValue())
}
object LoginAuthConfigReqObj {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.LoginAuthConfigReqObj
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.LoginAuthConfigReqObj =
      zio.aws.amplifybackend.model.LoginAuthConfigReqObj(
        awsCognitoIdentityPoolId.map(value => value),
        awsCognitoRegion.map(value => value),
        awsUserPoolsId.map(value => value),
        awsUserPoolsWebClientId.map(value => value)
      )
    def awsCognitoIdentityPoolId: Optional[__string]
    def awsCognitoRegion: Optional[__string]
    def awsUserPoolsId: Optional[__string]
    def awsUserPoolsWebClientId: Optional[__string]
    def getAwsCognitoIdentityPoolId: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("awsCognitoIdentityPoolId", awsCognitoIdentityPoolId)
    def getAwsCognitoRegion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("awsCognitoRegion", awsCognitoRegion)
    def getAwsUserPoolsId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("awsUserPoolsId", awsUserPoolsId)
    def getAwsUserPoolsWebClientId: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("awsUserPoolsWebClientId", awsUserPoolsWebClientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.LoginAuthConfigReqObj
  ) extends zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly {
    override val awsCognitoIdentityPoolId: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsCognitoIdentityPoolId())
        .map(value => value: __string)
    override val awsCognitoRegion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.awsCognitoRegion())
      .map(value => value: __string)
    override val awsUserPoolsId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.awsUserPoolsId())
      .map(value => value: __string)
    override val awsUserPoolsWebClientId: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsUserPoolsWebClientId())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.LoginAuthConfigReqObj
  ): zio.aws.amplifybackend.model.LoginAuthConfigReqObj.ReadOnly = new Wrapper(
    impl
  )
}
