package zio.aws.amplifybackend.model
import scala.jdk.CollectionConverters.*
sealed trait OAuthScopesElement {
  def unwrap
      : software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement
}
object OAuthScopesElement {
  def wrap(
      value: software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement
  ): zio.aws.amplifybackend.model.OAuthScopesElement = value match {
    case software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement.PHONE =>
      val r = PHONE
      r
    case software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement.EMAIL =>
      val r = EMAIL
      r
    case software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement.OPENID =>
      val r = OPENID
      r
    case software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement.PROFILE =>
      val r = PROFILE
      r
    case software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement.AWS_COGNITO_SIGNIN_USER_ADMIN =>
      val r = AWS_COGNITO_SIGNIN_USER_ADMIN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.amplifybackend.model.OAuthScopesElement {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement =
      software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement.UNKNOWN_TO_SDK_VERSION
  }
  case object PHONE extends zio.aws.amplifybackend.model.OAuthScopesElement {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement =
      software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement.PHONE
  }
  case object EMAIL extends zio.aws.amplifybackend.model.OAuthScopesElement {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement =
      software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement.EMAIL
  }
  case object OPENID extends zio.aws.amplifybackend.model.OAuthScopesElement {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement =
      software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement.OPENID
  }
  case object PROFILE extends zio.aws.amplifybackend.model.OAuthScopesElement {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement =
      software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement.PROFILE
  }
  case object AWS_COGNITO_SIGNIN_USER_ADMIN
      extends zio.aws.amplifybackend.model.OAuthScopesElement {
    override def unwrap
        : software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement =
      software.amazon.awssdk.services.amplifybackend.model.OAuthScopesElement.AWS_COGNITO_SIGNIN_USER_ADMIN
  }
}
