package zio.aws.amplifybackend.model
import zio.aws.amplifybackend.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetBackendApiResponse(
    appId: Optional[__string] = Optional.Absent,
    backendEnvironmentName: Optional[__string] = Optional.Absent,
    error: Optional[__string] = Optional.Absent,
    resourceConfig: Optional[
      zio.aws.amplifybackend.model.BackendAPIResourceConfig
    ] = Optional.Absent,
    resourceName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifybackend.model.GetBackendApiResponse = {
    import GetBackendApiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifybackend.model.GetBackendApiResponse
      .builder()
      .optionallyWith(appId.map(value => value: java.lang.String))(_.appId)
      .optionallyWith(
        backendEnvironmentName.map(value => value: java.lang.String)
      )(_.backendEnvironmentName)
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .optionallyWith(resourceConfig.map(value => value.buildAwsValue()))(
        _.resourceConfig
      )
      .optionallyWith(resourceName.map(value => value: java.lang.String))(
        _.resourceName
      )
      .build()
  }
  def asReadOnly: zio.aws.amplifybackend.model.GetBackendApiResponse.ReadOnly =
    zio.aws.amplifybackend.model.GetBackendApiResponse.wrap(buildAwsValue())
}
object GetBackendApiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifybackend.model.GetBackendApiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifybackend.model.GetBackendApiResponse =
      zio.aws.amplifybackend.model.GetBackendApiResponse(
        appId.map(value => value),
        backendEnvironmentName.map(value => value),
        error.map(value => value),
        resourceConfig.map(value => value.asEditable),
        resourceName.map(value => value)
      )
    def appId: Optional[__string]
    def backendEnvironmentName: Optional[__string]
    def error: Optional[__string]
    def resourceConfig: Optional[
      zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly
    ]
    def resourceName: Optional[__string]
    def getAppId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appId", appId)
    def getBackendEnvironmentName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("backendEnvironmentName", backendEnvironmentName)
    def getError: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("error", error)
    def getResourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("resourceConfig", resourceConfig)
    def getResourceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("resourceName", resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendApiResponse
  ) extends zio.aws.amplifybackend.model.GetBackendApiResponse.ReadOnly {
    override val appId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => value: __string)
    override val backendEnvironmentName: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backendEnvironmentName())
        .map(value => value: __string)
    override val error: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => value: __string)
    override val resourceConfig: Optional[
      zio.aws.amplifybackend.model.BackendAPIResourceConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceConfig())
      .map(value =>
        zio.aws.amplifybackend.model.BackendAPIResourceConfig.wrap(value)
      )
    override val resourceName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifybackend.model.GetBackendApiResponse
  ): zio.aws.amplifybackend.model.GetBackendApiResponse.ReadOnly = new Wrapper(
    impl
  )
}
